/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.mboxtable.MailMessageTable;
import com.selima.fbi.ui.content.mboxtable.MailMessageTableModel;
import com.selima.fbi.ui.content.mboxtable.SentMessageTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class SentMessageTable
extends MailMessageTable<IPAYEMessage> {
    static final Icon FAILED_ICON = SwingHelper.imageIcon("/img/16x16/apps/mail_error.png");
    static final Icon SUCCESS_ICON = SwingHelper.imageIcon("/img/16x16/apps/mail_ok.png");

    public SentMessageTable(ClientContext cctx) {
        super(cctx, new SentMessageTableModel());
        this.setDefaultRenderer(Object.class, new PAYEMessageRenderer(this.getDefaultRenderer(Object.class)));
    }

    private class PAYEMessageRenderer
    implements TableCellRenderer {
        private TableCellRenderer wrapped;

        private PAYEMessageRenderer(TableCellRenderer renderer) {
            this.wrapped = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            IPAYEMessage message = (IPAYEMessage)((MailMessageTableModel)SentMessageTable.this.getModel()).getMessages().get(row);
            if (message.isSuccessful()) {
                if (column == 0) {
                    label.setIcon(SUCCESS_ICON);
                }
                label.setForeground(Color.BLACK);
            } else {
                if (column == 0) {
                    label.setIcon(FAILED_ICON);
                }
                label.setForeground(new Color(224, 128, 64));
            }
            return label;
        }
    }
}

