/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IPayrollCheckedMessage;
import com.selima.fbi.core.IPayrollCheckedP6P6BMessage;
import com.selima.fbi.core.IPayrollCheckedP9Message;
import com.selima.fbi.core.ITrailMessage;
import com.selima.fbi.ui.common.table.RowTableModelColumn;
import com.selima.fbi.ui.common.table.RowTableModelGetter;
import com.selima.fbi.ui.content.mboxtable.DPSMessageTableModel;
import java.util.ArrayList;
import java.util.List;

class PayrollCheckedTableModel
extends DPSMessageTableModel {
    static RowTableModelColumn<? super IDPSMessage> PAYROLL_TAX_CODE_COLUMN = new PayrollTaxCodeColumn();
    static RowTableModelColumn<? super IDPSMessage> PAYROLL_TOTAL_PREVIOUS_PAY_COLUMN = new PayrollTotalPreviousPayColumn();
    static RowTableModelColumn<? super IDPSMessage> PAYROLL_TOTAL_PREVIOUS_TAX_COLUMN = new PayrollTotalPreviousTaxColumn();
    static RowTableModelColumn<? super IDPSMessage> PAYROLL_WARNING_COLUMN = new PayrollWarningColumn();

    PayrollCheckedTableModel() {
        this.orderedColumns = new ArrayList(this.orderedColumns);
        this.orderedColumns.add(PAYROLL_TAX_CODE_COLUMN);
        this.orderedColumns.add(PAYROLL_TOTAL_PREVIOUS_PAY_COLUMN);
        this.orderedColumns.add(PAYROLL_TOTAL_PREVIOUS_TAX_COLUMN);
        this.orderedColumns.add(PAYROLL_WARNING_COLUMN);
    }

    static class PayrollWarningColumn
    extends RowTableModelColumn<IDPSMessage> {
        PayrollWarningColumn() {
            super("Warning", 190, 2, new PayrollWarningGetter());
        }

        static class PayrollWarningGetter
        implements RowTableModelGetter<IDPSMessage> {
            PayrollWarningGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                String text;
                List<String> ids;
                String warning = null;
                if (row instanceof ITrailMessage && (ids = ((ITrailMessage)row).getPreceedingIds()).size() > 0) {
                    warning = "First " + ids.get(ids.size() - 1) + " must be dealt with.";
                }
                if (row instanceof IPayrollCheckedMessage && (text = ((IPayrollCheckedMessage)row).getPayrollWarningMessage()) != null) {
                    warning = warning == null ? text : warning + " " + text;
                }
                return warning;
            }
        }
    }

    static class PayrollTaxCodeColumn
    extends RowTableModelColumn<IDPSMessage> {
        PayrollTaxCodeColumn() {
            super("Payroll Tax Code", 120, 2, new PayrollTaxCodeGetter());
        }

        static class PayrollTaxCodeGetter
        implements RowTableModelGetter<IDPSMessage> {
            PayrollTaxCodeGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                String result = null;
                boolean week1Month1 = false;
                String taxRegime = null;
                if (row instanceof IPayrollCheckedP6P6BMessage) {
                    IPayrollCheckedP6P6BMessage p6 = (IPayrollCheckedP6P6BMessage)row;
                    week1Month1 = p6.isPayrollWeek1Month1Indicator();
                    taxRegime = p6.getPayrollTaxRegime();
                    result = p6.getPayrollTaxCode();
                }
                if (row instanceof IPayrollCheckedP9Message) {
                    IPayrollCheckedP9Message p9 = (IPayrollCheckedP9Message)row;
                    week1Month1 = p9.isPayrollWeek1Month1Indicator();
                    taxRegime = p9.getPayrollTaxRegime();
                    result = p9.getPayrollTaxCode();
                }
                if (week1Month1) {
                    return result + " (X)";
                }
                if (taxRegime != null) {
                    return "[" + taxRegime + "]" + result;
                }
                return result;
            }
        }
    }

    static class PayrollTotalPreviousPayColumn
    extends RowTableModelColumn<IDPSMessage> {
        PayrollTotalPreviousPayColumn() {
            super("Payroll Prev. Pay", 120, 4, new PayrollTotalPreviousPayGetter());
        }

        static class PayrollTotalPreviousPayGetter
        implements RowTableModelGetter<IDPSMessage> {
            PayrollTotalPreviousPayGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                Number number;
                if (row instanceof IPayrollCheckedP6P6BMessage && (number = ((IPayrollCheckedP6P6BMessage)row).getPayrollTotalPrevousPay()) instanceof Comparable) {
                    return (Comparable)Comparable.class.cast(number);
                }
                return null;
            }
        }
    }

    static class PayrollTotalPreviousTaxColumn
    extends RowTableModelColumn<IDPSMessage> {
        PayrollTotalPreviousTaxColumn() {
            super("Payroll Prev. Tax", 120, 4, new PayrollTotalPreviousTaxGetter());
        }

        static class PayrollTotalPreviousTaxGetter
        implements RowTableModelGetter<IDPSMessage> {
            PayrollTotalPreviousTaxGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                Number number;
                if (row instanceof IPayrollCheckedP6P6BMessage && (number = ((IPayrollCheckedP6P6BMessage)row).getPayrollTotalPrevousTax()) instanceof Comparable) {
                    return (Comparable)Comparable.class.cast(number);
                }
                return null;
            }
        }
    }
}

