/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IARMessage;
import com.selima.fbi.core.IARmnMessage;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IIncentiveLetterMessage;
import com.selima.fbi.core.IP11DbNotificationMessage;
import com.selima.fbi.core.IP35NotificationMessage;
import com.selima.fbi.core.IP6P6BMessage;
import com.selima.fbi.core.IP9Message;
import com.selima.fbi.core.IPGL1Message;
import com.selima.fbi.core.IPGL2Message;
import com.selima.fbi.core.ISL1Message;
import com.selima.fbi.core.ISL2Message;
import com.selima.fbi.ui.common.table.RowTableModelColumn;
import com.selima.fbi.ui.common.table.RowTableModelGetter;
import com.selima.fbi.ui.content.mboxtable.MailMessageTableModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DPSMessageTableModel
extends MailMessageTableModel<IDPSMessage> {
    static RowTableModelColumn<? super IDPSMessage> ID_COLUMN = new DpsIdColumn();
    static RowTableModelColumn<? super IDPSMessage> DATE_COLUMN = new MailMessageTableModel.DateColumn();
    static RowTableModelColumn<? super IDPSMessage> HMRC_OFFICE_COLUMN = new HmrcOfficeColumn();
    static RowTableModelColumn<? super IDPSMessage> EMPREF_COLUMN = new MailMessageTableModel.EmprefColumn();
    static RowTableModelColumn<? super IDPSMessage> SUBJECT_COLUMN = new MailMessageTableModel.SubjectColumn();
    static RowTableModelColumn<? super IDPSMessage> TYPE_COLUMN = new MailMessageTableModel.TypeColumn();
    static RowTableModelColumn<? super IDPSMessage> NINO_COLUMN = new NinoColumn();
    static RowTableModelColumn<? super IDPSMessage> WORKS_NUMBER_COLUMN = new WorksNumberColumn();
    static RowTableModelColumn<? super IDPSMessage> SURNAME_COLUMN = new SurnameColumn();
    static RowTableModelColumn<? super IDPSMessage> FORENAME_COLUMN = new ForenameColumn();
    static RowTableModelColumn<? super IDPSMessage> EFFECTIVE_DATE_COLUMN = new EffectiveDateColumn();
    static RowTableModelColumn<? super IDPSMessage> TAX_YEAR_COLUMN = new TaxYearColumn();
    static RowTableModelColumn<? super IDPSMessage> TAX_CODE_COLUMN = new TaxCodeColumn();
    static RowTableModelColumn<? super IDPSMessage> TOTAL_PREVIOUS_PAY_COLUMN = new TotalPreviousPayColumn();
    static RowTableModelColumn<? super IDPSMessage> TOTAL_PREVIOUS_TAX_COLUMN = new TotalPreviousTaxColumn();
    static RowTableModelColumn<? super IDPSMessage> LIABILITY_COLUMN = new LiabilityColumn();
    static RowTableModelColumn<? super IDPSMessage> EMPLOYER_NAME_COLUMN = new EmployerNameColumn();
    static RowTableModelColumn<? super IDPSMessage> AOREF_COLUMN = new AoRefColumn();
    static RowTableModelColumn<? super IDPSMessage> DUE_DATE_COLUMN = new DueDateColumn();
    static RowTableModelColumn<? super IDPSMessage> INCENTIVE_AMOUNT_COLUMN = new IncentiveAmountColumn();
    static RowTableModelColumn<? super IDPSMessage> HEADER_TEXT_COLUMN = new HeaderTextColumn();
    static RowTableModelColumn<? super IDPSMessage> NOTIFICATION_TEXT_COLUMN = new NotificationTextColumn();
    static RowTableModelColumn<? super IDPSMessage> TRANSFERRED_DATE_COLUMN = new TransferredDateColumn();
    static RowTableModelColumn<? super IDPSMessage> PLAN_TYPE_COLUMN = new PlanTypeColumn();
    static RowTableModelColumn<? super IDPSMessage> TAX_REGIME_COLUMN = new TaxRegimeColumn();
    List<RowTableModelColumn<?>> orderedColumns = Arrays.asList(DATE_COLUMN, TYPE_COLUMN, EMPREF_COLUMN, SUBJECT_COLUMN, NINO_COLUMN, WORKS_NUMBER_COLUMN, SURNAME_COLUMN, FORENAME_COLUMN, TAX_CODE_COLUMN, TAX_REGIME_COLUMN, EFFECTIVE_DATE_COLUMN, TOTAL_PREVIOUS_PAY_COLUMN, TOTAL_PREVIOUS_TAX_COLUMN, INCENTIVE_AMOUNT_COLUMN, LIABILITY_COLUMN, DUE_DATE_COLUMN, PLAN_TYPE_COLUMN, EMPLOYER_NAME_COLUMN, HEADER_TEXT_COLUMN, NOTIFICATION_TEXT_COLUMN, AOREF_COLUMN, HMRC_OFFICE_COLUMN, TAX_YEAR_COLUMN);

    protected DPSMessageTableModel() {
        this(new RowTableModelColumn[]{ID_COLUMN, DATE_COLUMN, TYPE_COLUMN, SUBJECT_COLUMN, EMPREF_COLUMN, TAX_YEAR_COLUMN});
    }

    protected DPSMessageTableModel(RowTableModelColumn<? super IDPSMessage> ... columns) {
        super((RowTableModelColumn<? super MessageType>[])columns);
    }

    public void setColumns(Set<RowTableModelColumn<?>> columns) {
        LinkedList<RowTableModelColumn<? super IDPSMessage>> list = new LinkedList<RowTableModelColumn<? super IDPSMessage>>(Collections.singleton(ID_COLUMN));
        for (RowTableModelColumn<?> column : this.orderedColumns) {
            if (!columns.contains(column)) continue;
            list.add(column);
        }
        super.setColumns(list.toArray(new RowTableModelColumn[list.size()]));
    }

    @Override
    public Map<String, RowTableModelColumn<?>> getMapOfColumns() {
        HashMap map = new HashMap(this.orderedColumns.size() + 1);
        map.put(ID_COLUMN.getTitle(), ID_COLUMN);
        for (RowTableModelColumn<?> column : this.orderedColumns) {
            map.put(column.getTitle(), column);
        }
        return Collections.unmodifiableMap(map);
    }

    public List<RowTableModelColumn<?>> getOrderedColumns() {
        return this.orderedColumns;
    }

    static class TaxRegimeColumn
    extends RowTableModelColumn<IDPSMessage> {
        TaxRegimeColumn() {
            super("Tax Regime", 105, 2, new TaxRegimeGetter());
        }

        static class TaxRegimeGetter
        implements RowTableModelGetter<IDPSMessage> {
            TaxRegimeGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IP6P6BMessage) {
                    return ((IP6P6BMessage)row).getTaxRegime();
                }
                if (row instanceof IP9Message) {
                    return ((IP9Message)row).getTaxRegime();
                }
                return null;
            }
        }
    }

    static class PlanTypeColumn
    extends RowTableModelColumn<IDPSMessage> {
        PlanTypeColumn() {
            super("Plan Type", 105, 2, new PlanTypeGetter());
        }

        static class PlanTypeGetter
        implements RowTableModelGetter<IDPSMessage> {
            PlanTypeGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof ISL1Message) {
                    return ((ISL1Message)row).getPlanType();
                }
                return null;
            }
        }
    }

    static class TransferredDateColumn
    extends RowTableModelColumn<IDPSMessage> {
        TransferredDateColumn() {
            super("Transfer Date", 105, 2, new TransferredDateGetter());
        }

        static class TransferredDateGetter
        implements RowTableModelGetter<IDPSMessage> {
            TransferredDateGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                return row.getTransferDate();
            }
        }
    }

    static class IDGetter
    implements RowTableModelGetter<IDPSMessage> {
        IDGetter() {
        }

        @Override
        public Comparable<?> getValue(IDPSMessage message) {
            return message.getSequenceNumber();
        }
    }

    static class DpsIdColumn
    extends MailMessageTableModel.IdColumn<IDPSMessage> {
        DpsIdColumn() {
        }

        @Override
        protected RowTableModelGetter<IDPSMessage> createGetter() {
            return new IDGetter();
        }
    }

    static class HmrcOfficeColumn
    extends RowTableModelColumn<IDPSMessage> {
        HmrcOfficeColumn() {
            this(100);
        }

        HmrcOfficeColumn(int size) {
            super("Office", size, 2, new HmrcOfficeGetter());
        }

        static class HmrcOfficeGetter
        implements RowTableModelGetter<IDPSMessage> {
            HmrcOfficeGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage message) {
                if (message instanceof IARMessage) {
                    return ((IARMessage)message).getHMRCoffice();
                }
                if (message instanceof IP35NotificationMessage) {
                    return ((IP35NotificationMessage)message).getHMRCOffice();
                }
                if (message instanceof IP11DbNotificationMessage) {
                    return ((IP11DbNotificationMessage)message).getHMRCOffice();
                }
                return null;
            }
        }
    }

    static class NinoColumn
    extends RowTableModelColumn<IDPSMessage> {
        NinoColumn() {
            super("NINO", 115, 2, new NinoGetter());
        }

        static class NinoGetter
        implements RowTableModelGetter<IDPSMessage> {
            NinoGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IP6P6BMessage) {
                    return ((IP6P6BMessage)row).getNino();
                }
                if (row instanceof IP9Message) {
                    return ((IP9Message)row).getNino();
                }
                if (row instanceof ISL1Message) {
                    return ((ISL1Message)row).getNino();
                }
                if (row instanceof ISL2Message) {
                    return ((ISL2Message)row).getNino();
                }
                if (row instanceof IPGL1Message) {
                    return ((IPGL1Message)row).getNino();
                }
                if (row instanceof IPGL2Message) {
                    return ((IPGL2Message)row).getNino();
                }
                return null;
            }
        }
    }

    static class WorksNumberColumn
    extends RowTableModelColumn<IDPSMessage> {
        WorksNumberColumn() {
            super("Works Number", 110, 0, new WorksNumberGetter());
        }

        static class WorksNumberGetter
        implements RowTableModelGetter<IDPSMessage> {
            WorksNumberGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IP6P6BMessage) {
                    return ((IP6P6BMessage)row).getWorksNumber();
                }
                if (row instanceof IP9Message) {
                    return ((IP9Message)row).getWorksNumber();
                }
                if (row instanceof ISL1Message) {
                    return ((ISL1Message)row).getWorksNumber();
                }
                if (row instanceof ISL2Message) {
                    return ((ISL2Message)row).getWorksNumber();
                }
                if (row instanceof IPGL1Message) {
                    return ((IPGL1Message)row).getWorksNumber();
                }
                if (row instanceof IPGL2Message) {
                    return ((IPGL2Message)row).getWorksNumber();
                }
                return null;
            }
        }
    }

    static class SurnameColumn
    extends RowTableModelColumn<IDPSMessage> {
        SurnameColumn() {
            super("Surname", 120, 2, new SurnameGetter());
        }

        static class SurnameGetter
        implements RowTableModelGetter<IDPSMessage> {
            SurnameGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IP6P6BMessage) {
                    return ((IP6P6BMessage)row).getSurname();
                }
                if (row instanceof IP9Message) {
                    return ((IP9Message)row).getSurname();
                }
                if (row instanceof ISL1Message) {
                    return ((ISL1Message)row).getSurname();
                }
                if (row instanceof ISL2Message) {
                    return ((ISL2Message)row).getSurname();
                }
                if (row instanceof IPGL1Message) {
                    return ((IPGL1Message)row).getSurname();
                }
                if (row instanceof IPGL2Message) {
                    return ((IPGL2Message)row).getSurname();
                }
                return null;
            }
        }
    }

    static class ForenameColumn
    extends RowTableModelColumn<IDPSMessage> {
        ForenameColumn() {
            super("Forename", 125, 2, new ForenameGetter());
        }

        static class ForenameGetter
        implements RowTableModelGetter<IDPSMessage> {
            ForenameGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                List<String> forenames = null;
                if (row instanceof IP6P6BMessage) {
                    forenames = ((IP6P6BMessage)row).getForename();
                }
                if (row instanceof IP9Message) {
                    forenames = ((IP9Message)row).getForename();
                }
                if (row instanceof ISL1Message) {
                    forenames = ((ISL1Message)row).getForename();
                }
                if (row instanceof ISL2Message) {
                    forenames = ((ISL2Message)row).getForename();
                }
                if (row instanceof IPGL1Message) {
                    forenames = ((IPGL1Message)row).getForename();
                }
                if (row instanceof IPGL2Message) {
                    forenames = ((IPGL2Message)row).getForename();
                }
                if (forenames != null && forenames.size() > 0) {
                    StringBuilder result = new StringBuilder(forenames.get(0));
                    for (String forename : forenames.subList(1, forenames.size())) {
                        result.append(' ').append(forename);
                    }
                    return result.toString();
                }
                return null;
            }
        }
    }

    static class EffectiveDateColumn
    extends RowTableModelColumn<IDPSMessage> {
        EffectiveDateColumn() {
            super("Effective Date", 100, 0, new EffectiveDateGetter());
        }

        static class EffectiveDateGetter
        implements RowTableModelGetter<IDPSMessage> {
            EffectiveDateGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IP6P6BMessage) {
                    return ((IP6P6BMessage)row).getEffectiveDate();
                }
                if (row instanceof IP9Message) {
                    return ((IP9Message)row).getEffectiveDate();
                }
                if (row instanceof ISL1Message) {
                    return ((ISL1Message)row).getStartDate();
                }
                if (row instanceof ISL2Message) {
                    return ((ISL2Message)row).getStopDate();
                }
                if (row instanceof IPGL1Message) {
                    return ((IPGL1Message)row).getStartDate();
                }
                if (row instanceof IPGL2Message) {
                    return ((IPGL2Message)row).getStopDate();
                }
                return null;
            }
        }
    }

    static class TaxYearColumn
    extends RowTableModelColumn<IDPSMessage> {
        TaxYearColumn() {
            super("Tax Year", 80, 0, new TaxYearGetter());
        }

        static class TaxYearGetter
        implements RowTableModelGetter<IDPSMessage> {
            TaxYearGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                int result = row.getTaxYearEnd();
                return result == -1 ? null : Integer.valueOf(result);
            }
        }
    }

    static class TaxCodeColumn
    extends RowTableModelColumn<IDPSMessage> {
        TaxCodeColumn() {
            super("Tax Code", 90, 2, new TaxCodeGetter());
        }

        static class TaxCodeGetter
        implements RowTableModelGetter<IDPSMessage> {
            TaxCodeGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                String result = null;
                boolean week1Month1 = false;
                if (row instanceof IP6P6BMessage) {
                    IP6P6BMessage p6 = (IP6P6BMessage)row;
                    week1Month1 = p6.getWeek1Month1Indicator();
                    result = p6.getTaxCode();
                }
                if (row instanceof IP9Message) {
                    IP9Message p9 = (IP9Message)row;
                    week1Month1 = p9.getWeek1Month1Indicator();
                    result = p9.getTaxCode();
                }
                if (week1Month1) {
                    return result + " (X)";
                }
                return result;
            }
        }
    }

    static class TotalPreviousPayColumn
    extends RowTableModelColumn<IDPSMessage> {
        TotalPreviousPayColumn() {
            super("Total Prev. Pay", 115, 4, new TotalPreviousPayGetter());
        }

        static class TotalPreviousPayGetter
        implements RowTableModelGetter<IDPSMessage> {
            TotalPreviousPayGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                Number number;
                if (row instanceof IP6P6BMessage && (number = ((IP6P6BMessage)row).getTotalPreviousPay()) instanceof Comparable) {
                    return (Comparable)Comparable.class.cast(number);
                }
                return null;
            }
        }
    }

    static class TotalPreviousTaxColumn
    extends RowTableModelColumn<IDPSMessage> {
        TotalPreviousTaxColumn() {
            super("Total Prev. Tax", 115, 4, new TotalPreviousTaxGetter());
        }

        static class TotalPreviousTaxGetter
        implements RowTableModelGetter<IDPSMessage> {
            TotalPreviousTaxGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                Number number;
                if (row instanceof IP6P6BMessage && (number = ((IP6P6BMessage)row).getTotalPreviousTax()) instanceof Comparable) {
                    return (Comparable)Comparable.class.cast(number);
                }
                return null;
            }
        }
    }

    static class LiabilityColumn
    extends RowTableModelColumn<IDPSMessage> {
        LiabilityColumn() {
            super("Liability", 220, 2, new LiabilityGetter());
        }

        static class LiabilityGetter
        implements RowTableModelGetter<IDPSMessage> {
            LiabilityGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                IARMessage ar;
                List<String> liability;
                if (row instanceof IARMessage && (liability = (ar = (IARMessage)row).getLiability()) != null && liability.size() > 0) {
                    StringBuilder result = new StringBuilder(liability.get(0));
                    for (String l : liability.subList(1, liability.size())) {
                        result.append(", ").append(l);
                    }
                    return result.toString();
                }
                return null;
            }
        }
    }

    static class EmployerNameColumn
    extends RowTableModelColumn<IDPSMessage> {
        EmployerNameColumn() {
            super("Employer Name", 140, 2, new EmployerNameGetter());
        }

        static class EmployerNameGetter
        implements RowTableModelGetter<IDPSMessage> {
            EmployerNameGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                List<String> employerNames;
                if (row instanceof IARMessage) {
                    return ((IARMessage)row).getEmployerName();
                }
                if (row instanceof IIncentiveLetterMessage && (employerNames = ((IIncentiveLetterMessage)row).getEmployerNames()) != null && employerNames.size() > 0) {
                    StringBuilder result = new StringBuilder(employerNames.get(0));
                    for (String name : employerNames.subList(1, employerNames.size())) {
                        result.append(' ').append(name);
                    }
                    return result.toString();
                }
                if (row instanceof IP35NotificationMessage) {
                    return ((IP35NotificationMessage)row).getEmployerName();
                }
                if (row instanceof IP11DbNotificationMessage) {
                    return ((IP11DbNotificationMessage)row).getEmployerName();
                }
                return null;
            }
        }
    }

    static class AoRefColumn
    extends RowTableModelColumn<IDPSMessage> {
        AoRefColumn() {
            super("AO Ref", 130, 2, new AORefGetter());
        }

        static class AORefGetter
        implements RowTableModelGetter<IDPSMessage> {
            AORefGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IARMessage) {
                    return ((IARMessage)row).getAccountsOfficeReference();
                }
                if (row instanceof IP35NotificationMessage) {
                    return ((IP35NotificationMessage)row).getAccountsOfficeReference();
                }
                if (row instanceof IP11DbNotificationMessage) {
                    return ((IP11DbNotificationMessage)row).getAccountsOfficeReference();
                }
                return null;
            }
        }
    }

    static class DueDateColumn
    extends RowTableModelColumn<IDPSMessage> {
        DueDateColumn() {
            super("Due Date", 90, 0, new DueDateGetter());
        }

        static class DueDateGetter
        implements RowTableModelGetter<IDPSMessage> {
            DueDateGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IARmnMessage) {
                    return ((IARmnMessage)row).getDueDate();
                }
                return null;
            }
        }
    }

    static class IncentiveAmountColumn
    extends RowTableModelColumn<IDPSMessage> {
        IncentiveAmountColumn() {
            super("Incentive Amount", 125, 4, new IncentiveAmountGetter());
        }

        static class IncentiveAmountGetter
        implements RowTableModelGetter<IDPSMessage> {
            IncentiveAmountGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                Number incentiveAmount;
                if (row instanceof IIncentiveLetterMessage && (incentiveAmount = ((IIncentiveLetterMessage)row).getIncentiveAmount()) instanceof Comparable) {
                    return (Comparable)((Object)incentiveAmount);
                }
                return null;
            }
        }
    }

    static class HeaderTextColumn
    extends RowTableModelColumn<IDPSMessage> {
        HeaderTextColumn() {
            super("Header Text", 200, 2, new HeaderTextGetter());
        }

        static class HeaderTextGetter
        implements RowTableModelGetter<IDPSMessage> {
            HeaderTextGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IP35NotificationMessage) {
                    return ((IP35NotificationMessage)row).getHeaderText();
                }
                if (row instanceof IP11DbNotificationMessage) {
                    return ((IP11DbNotificationMessage)row).getHeaderText();
                }
                return null;
            }
        }
    }

    static class NotificationTextColumn
    extends RowTableModelColumn<IDPSMessage> {
        NotificationTextColumn() {
            super("Notification Text", 240, 2, new HeaderTextGetter());
        }

        static class HeaderTextGetter
        implements RowTableModelGetter<IDPSMessage> {
            HeaderTextGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IP35NotificationMessage) {
                    return ((IP35NotificationMessage)row).getNotificationText();
                }
                if (row instanceof IP11DbNotificationMessage) {
                    return ((IP11DbNotificationMessage)row).getNotificationText();
                }
                return null;
            }
        }
    }
}

