/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.ui.common.table.RowTableModelColumn;
import com.selima.fbi.ui.content.mboxtable.DPSMessageTable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ColumnSelectionPanel
extends JPanel {
    DPSMessageTable table;

    public ColumnSelectionPanel(DPSMessageTable table) {
        super(new GridLayout(11, 2));
        this.table = table;
        TreeSet columns = new TreeSet(new Comparator<RowTableModelColumn<?>>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(RowTableModelColumn<?> o1, RowTableModelColumn<?> o2) {
                return this.collator.compare(o1.getTitle(), o2.getTitle());
            }
        });
        columns.addAll(table.getModel().getOrderedColumns());
        for (RowTableModelColumn rowTableModelColumn : columns) {
            this.add(new ColumnCheckBox(rowTableModelColumn));
        }
        this.addAncestorListener(new OnDisplaySynchronizer());
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setToolTipText("Grid Columns");
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rec = this.getBounds();
        Insets insets = this.getInsets();
        g.setColor(this.getBackground());
        g.fillRect(rec.x + insets.left, rec.y + insets.top, rec.width - insets.right - insets.left, rec.height - insets.bottom - insets.top);
    }

    class ColumnCheckBox
    extends JCheckBox {
        final RowTableModelColumn<?> column;

        public ColumnCheckBox(final RowTableModelColumn<?> column) {
            super(column.getTitle());
            this.setOpaque(true);
            this.column = column;
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean selected;
                    List columns = Arrays.asList(ColumnSelectionPanel.this.table.getModel().getColumns());
                    boolean bl = selected = e.getStateChange() == 1;
                    if (selected != columns.contains(column)) {
                        HashSet set = new HashSet(columns);
                        if (selected) {
                            set.add(column);
                        } else {
                            set.remove(column);
                        }
                        ColumnSelectionPanel.this.table.getModel().setColumns(set);
                    }
                }
            });
            this.getInputMap(0).put(KeyStroke.getKeyStroke("RIGHT"), "focus-next");
            this.getInputMap(0).put(KeyStroke.getKeyStroke("LEFT"), "focus-prev");
            this.getInputMap(0).put(KeyStroke.getKeyStroke("UP"), "focus-prev-prev");
            this.getInputMap(0).put(KeyStroke.getKeyStroke("DOWN"), "focus-next-next");
            this.getActionMap().put("focus-next", new FocusAction(){

                @Override
                int focusIndex(int index) {
                    return index + 1;
                }
            });
            this.getActionMap().put("focus-prev", new FocusAction(){

                @Override
                int focusIndex(int index) {
                    return index - 1;
                }
            });
            this.getActionMap().put("focus-next-next", new FocusAction(){

                @Override
                int focusIndex(int index) {
                    return index + 2;
                }
            });
            this.getActionMap().put("focus-prev-prev", new FocusAction(){

                @Override
                int focusIndex(int index) {
                    return index - 2;
                }
            });
        }

        abstract class FocusAction
        extends AbstractAction {
            FocusAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Component> components = Arrays.asList(ColumnCheckBox.this.getParent().getComponents());
                int index = this.focusIndex(components.indexOf(ColumnCheckBox.this));
                if (index < 0) {
                    index += components.size();
                } else if (index >= components.size()) {
                    index -= components.size();
                }
                components.get(index).requestFocusInWindow();
            }

            abstract int focusIndex(int var1);
        }
    }

    final class OnDisplaySynchronizer
    implements AncestorListener {
        OnDisplaySynchronizer() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            List list = Arrays.asList(ColumnSelectionPanel.this.table.getModel().getColumns());
            for (Component c : ColumnSelectionPanel.this.getComponents()) {
                if (!(c instanceof ColumnCheckBox)) continue;
                ColumnCheckBox cbox = (ColumnCheckBox)c;
                cbox.setSelected(list.contains(cbox.column));
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

