/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IArchivedMessage;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.ITrailMessage;
import com.selima.fbi.ui.common.table.RowTableModelColumn;
import com.selima.fbi.ui.common.table.RowTableModelGetter;
import com.selima.fbi.ui.content.mboxtable.DPSMessageTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ArchiveMessageTableModel
extends DPSMessageTableModel {
    static RowTableModelColumn<? super IDPSMessage> DELETION_DATE_COLUMN = new DeletionDateColumn();
    static RowTableModelColumn<? super IDPSMessage> ORIGINAL_FOLDER_COLUMN = new OriginalFolderColumn();
    static RowTableModelColumn<? super IDPSMessage> PAYROLL_WARNING_MESSAGE_COLUMN = new PayrollWarningMessageColumn();

    ArchiveMessageTableModel() {
        super(new RowTableModelColumn[]{DELETION_DATE_COLUMN, ID_COLUMN, DATE_COLUMN, TYPE_COLUMN, SUBJECT_COLUMN, EMPREF_COLUMN, ORIGINAL_FOLDER_COLUMN, PAYROLL_WARNING_MESSAGE_COLUMN});
        this.orderedColumns = new ArrayList(this.orderedColumns);
        this.orderedColumns.add(0, DELETION_DATE_COLUMN);
        this.orderedColumns.add(ORIGINAL_FOLDER_COLUMN);
        this.orderedColumns.add(TRANSFERRED_DATE_COLUMN);
        this.orderedColumns.add(PAYROLL_WARNING_MESSAGE_COLUMN);
        this.sort(Arrays.asList(this.getColumns()).indexOf(DELETION_DATE_COLUMN));
    }

    static class PayrollWarningMessageColumn
    extends RowTableModelColumn<IDPSMessage> {
        PayrollWarningMessageColumn() {
            super("Warning", 190, 2, new PayrollWarningMessageGetter());
        }

        static class PayrollWarningMessageGetter
        implements RowTableModelGetter<IDPSMessage> {
            PayrollWarningMessageGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                String text;
                List<String> ids;
                String warning = null;
                if (row instanceof ITrailMessage && (ids = ((ITrailMessage)row).getPreceedingIds()).size() > 0) {
                    warning = "First " + ids.get(ids.size() - 1) + " must be dealt with.";
                }
                if (row instanceof IDPSMessage && (text = row.getPayrollWarningMessage()) != null) {
                    warning = warning == null ? text : warning + " " + text;
                }
                return warning;
            }
        }
    }

    static class DeletionDateColumn
    extends RowTableModelColumn<IDPSMessage> {
        DeletionDateColumn() {
            super("Deleted Date", 110, 2, new DeletionDateGetter());
        }

        static class DeletionDateGetter
        implements RowTableModelGetter<IDPSMessage> {
            DeletionDateGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IArchivedMessage) {
                    return ((IArchivedMessage)((Object)row)).getDeletionDate();
                }
                return null;
            }
        }
    }

    static class OriginalFolderColumn
    extends RowTableModelColumn<IDPSMessage> {
        OriginalFolderColumn() {
            super("Orig. Folder", 105, 2, new OriginalFolderGetter());
        }

        static class OriginalFolderGetter
        implements RowTableModelGetter<IDPSMessage> {
            OriginalFolderGetter() {
            }

            @Override
            public Comparable<?> getValue(IDPSMessage row) {
                if (row instanceof IArchivedMessage) {
                    return ((IArchivedMessage)((Object)row)).getOriginalFolder();
                }
                return null;
            }
        }
    }
}

