/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.mboxtable;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.mboxtable.ArchiveMessageTableModel;
import com.selima.fbi.ui.content.mboxtable.DPSMessageTable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class ArchiveMessageTable
extends DPSMessageTable {
    public ArchiveMessageTable(ClientContext cctx) {
        super(cctx, new ArchiveMessageTableModel());
        this.setDefaultRenderer(Object.class, new ArchiveRenderer(this.getDefaultRenderer(Object.class)));
    }

    private static class ArchiveRenderer
    implements TableCellRenderer {
        Icon NOT_APPLIED_ICON = SwingHelper.imageIcon("/img/16x16/actions/mail_not_applied.png");
        Icon APPLIED_ICON = SwingHelper.imageIcon("/img/16x16/actions/mail_send.png");
        private TableCellRenderer wrapped;

        private ArchiveRenderer(TableCellRenderer renderer) {
            this.wrapped = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            IDPSMessage message = (IDPSMessage)((DPSMessageTable)table).getModel().getRow(row).getRowData();
            if (column == 0) {
                if (message.isTransferrable()) {
                    label.setIcon(this.NOT_APPLIED_ICON);
                } else if (message.isTransferred()) {
                    label.setIcon(this.APPLIED_ICON);
                }
            }
            if (message.isTransferrable()) {
                label.setForeground(new Color(128, 64, 0));
            } else if (message.isDeletable()) {
                label.setForeground(Color.BLACK);
            } else {
                label.setForeground(Color.GRAY);
            }
            return label;
        }
    }
}

