/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.empsel;

import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.common.RolloverBorderButton;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.empsel.AddEmpRefAction;
import com.selima.fbi.ui.content.empsel.EmpSelectionEvent;
import com.selima.fbi.ui.content.empsel.EmpSelectionList;
import com.selima.fbi.ui.content.empsel.EmpSelectionListener;
import com.selima.fbi.ui.content.empsel.EmpSelectionModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class EmpSelectionPanel
extends JPanel {
    Dimension preferredSizeCache;
    EmpSelectionList list;
    public static final String LAYOUT = "+------------------------------------------------------------------+\n| List NONE CENTER  0 0 0 0   0%   0%                              |\n|                                                                  |\n+-------------------+--------------------+-------------------------+\n| SearchBox         | SelectAll          | NewButton NONE          |\n| NONE    WEST      | NONE EAST          |        EAST 3 0 0 0 0%  |\n| 3 0 0 0 0%        | 3 0 0 0            |                         |\n+-------------------+--------------------+-------------------------+\n";

    public EmpSelectionPanel(MailServiceClientContext context, final EmpSelectionModel empModel) {
        super(new ResourceDrivenLayout(LAYOUT));
        this.setOpaque(false);
        this.setToolTipText("Employer References");
        this.list = new EmpSelectionList(context.getCurrentUser(), empModel, context.getReferenceManager());
        this.list.getModel().addListDataListener(new Resizer());
        JScrollPane scrollPane = new JScrollPane(this.list);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        super.add((Component)scrollPane, "List");
        super.add((Component)new JCheckBox("Active Seach"){
            {
                super(x0);
                this.setVisible(empModel.isSearchAllowed());
                this.setModel(new ActiveSearchModel(empModel));
            }
        }, "SearchBox");
        super.add((Component)new RolloverBorderButton(new SelectAllAction()){
            {
                EmpSelectionPanel.this.setupButton(this, "Select All", "/img/16x16/actions/selectall.png", "Select All");
            }
        }, "SelectAll");
        super.add((Component)new RolloverBorderButton(new AddEmpRefAction(context, empModel)){
            {
                EmpSelectionPanel.this.setupButton(this, "Add", "/img/16x16/actions/filenew.png", "New Employer Reference");
            }
        }, "NewButton");
        this.setOpaque(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.preferredSizeCache = this.getPreferredSize();
    }

    EmpSelectionList getList() {
        return this.list;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        Dimension newSize = this.getPreferredSize();
        if (!newSize.equals(this.preferredSizeCache)) {
            Dimension oldSize = this.preferredSizeCache;
            this.preferredSizeCache = newSize;
            this.firePropertyChange("preferredSize", oldSize, newSize);
        }
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        Insets insets = this.getInsets();
        g.fillRect(insets.left, insets.top, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.top - insets.bottom);
        super.paint(g);
    }

    private void setupButton(JButton button, String name, String iconPath, String toolTip) {
        button.setIcon(SwingHelper.imageIcon(iconPath));
        button.setToolTipText(toolTip);
        button.setText(name);
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EmpSelectionPanel.this.list.getSelectionModel().setSelectionInterval(0, EmpSelectionPanel.this.list.getModel().getSize() - 1);
        }
    }

    class ActiveSearchModel
    extends JToggleButton.ToggleButtonModel
    implements EmpSelectionListener {
        EmpSelectionModel model;

        ActiveSearchModel(EmpSelectionModel model) {
            this.model = model;
            super.setSelected(model.isActiveSearch());
            model.addListener(this);
        }

        @Override
        public void setSelected(boolean state) {
            this.model.setActiveSearch(state);
        }

        @Override
        public void selectionChange(EmpSelectionEvent evt) {
            switch (evt.getType()) {
                case ACTIVE_SEARCH_ON: {
                    super.setSelected(true);
                    break;
                }
                case ACTIVE_SEARCH_OFF: {
                    super.setSelected(false);
                }
            }
        }
    }

    class Resizer
    implements ListDataListener {
        Resizer() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            EmpSelectionPanel.this.invalidate();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            EmpSelectionPanel.this.invalidate();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            EmpSelectionPanel.this.invalidate();
        }
    }
}

