/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.empsel;

import com.selima.fbi.ui.content.empsel.EmpSelectionEvent;
import com.selima.fbi.ui.content.empsel.EmpSelectionListener;
import com.selima.fbi.ui.content.empsel.EventType;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

class EmpSelectionModel {
    boolean activeSearch;
    boolean searchAllowed;
    List<String> selection = new ArrayList<String>();
    EventBroadcast<EmpSelectionListener> listeners = EventBroadcastFactory.createEventBroadcast(EmpSelectionListener.class);

    EmpSelectionModel(boolean searchAllowed, String[] initialSelection) {
        this.searchAllowed = searchAllowed;
        this.activeSearch = searchAllowed;
        this.selection.addAll(Arrays.asList(initialSelection));
    }

    public boolean isSearchAllowed() {
        return this.searchAllowed;
    }

    public List<String> getSelected() {
        return new ArrayList<String>(this.selection);
    }

    public boolean isActiveSearch() {
        return this.activeSearch;
    }

    public boolean isSelected(String empRef) {
        return !this.activeSearch && this.selection.contains(empRef);
    }

    public void setActiveSearch(boolean state) {
        assert (this.searchAllowed);
        if (state == this.activeSearch) {
            return;
        }
        if (state) {
            this.activeSearch = true;
            for (String empRef : this.selection) {
                this.fireUnselected(empRef);
            }
            this.fireActiveSearch(true);
        } else {
            this.activeSearch = false;
            this.fireActiveSearch(false);
            for (String empRef : this.selection) {
                this.fireSelected(empRef);
            }
        }
    }

    public void select(String empRef) {
        if (this.activeSearch) {
            this.selection.clear();
            this.selection.add(empRef);
            this.activeSearch = false;
            this.fireActiveSearch(false);
        } else {
            if (this.selection.contains(empRef)) {
                return;
            }
            this.selection.add(empRef);
        }
        this.fireSelected(empRef);
    }

    public void unselect(String empRef) {
        assert (!this.activeSearch);
        boolean found = this.selection.remove(empRef);
        assert (found);
        this.fireUnselected(empRef);
    }

    public void refreshData(List<String> empRefs) {
        Iterator<String> it = this.selection.iterator();
        while (it.hasNext()) {
            String empRef = it.next();
            if (empRefs.contains(empRef)) continue;
            it.remove();
            this.fireUnselected(empRef);
        }
    }

    public void addListener(EmpSelectionListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeListener(EmpSelectionListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void fireActiveSearch(boolean state) {
        ((EmpSelectionListener)this.listeners.getListener()).selectionChange(new EmpSelectionEvent(this, state ? EventType.ACTIVE_SEARCH_ON : EventType.ACTIVE_SEARCH_OFF, ""));
    }

    private void fireSelected(String empRef) {
        ((EmpSelectionListener)this.listeners.getListener()).selectionChange(new EmpSelectionEvent(this, EventType.SELECTED_EMPREF, empRef));
    }

    private void fireUnselected(String empRef) {
        ((EmpSelectionListener)this.listeners.getListener()).selectionChange(new EmpSelectionEvent(this, EventType.UNSELECTED_EMPREF, empRef));
    }
}

