/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.empsel;

import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.content.empsel.EmpSelectionButton;
import com.selima.fbi.ui.content.empsel.EmpSelectionField;
import com.selima.fbi.ui.content.empsel.EmpSelectionListener;
import com.selima.fbi.ui.content.empsel.EmpSelectionModel;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class EmpSelectionBox
extends Box {
    static final String[] EMP_ARRAY = new String[0];
    EmpSelectionModel model;
    EmpSelectionButton button;
    EmpSelectionField label;

    public EmpSelectionBox(MailServiceClientContext context, boolean searchAllowed) {
        super(0);
        this.model = new EmpSelectionModel(searchAllowed, context.getCurrentUser().getEmpRef());
        this.add(EmpSelectionBox.createHorizontalStrut(1));
        this.button = new EmpSelectionButton(context, this.model);
        this.add(this.button);
        this.add(EmpSelectionBox.createHorizontalStrut(2));
        this.label = new EmpSelectionField(this.model, context.getReferenceManager());
        this.add(this.label);
        this.enableModelRefresh(context);
        this.enableLabelClick();
        Dimension size = this.getPreferredSize();
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setAlignmentY(0.5f);
    }

    private void enableLabelClick() {
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                EmpSelectionBox.this.button.doClick();
                if (!EmpSelectionBox.this.button.isPopupVisible()) {
                    EmpSelectionBox.this.button.requestFocusInWindow();
                }
            }
        });
    }

    private void enableModelRefresh(final MailServiceClientContext context) {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                EmpSelectionBox.this.model.refreshData(Arrays.asList(context.getCurrentUser().getEmpRef()));
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    public boolean isActiveSearch() {
        return this.model.isActiveSearch();
    }

    public String[] getEmpRefs() {
        return this.model.getSelected().toArray(EMP_ARRAY);
    }

    public void removeEmpSelectionListener(EmpSelectionListener listener) {
        this.model.removeListener(listener);
    }

    public void addEmpSelectionListener(EmpSelectionListener listener) {
        this.model.addListener(listener);
    }
}

