/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.empsel;

import com.selima.fbi.CancelException;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.AbstractAddEmpRefAction;
import com.selima.fbi.ui.content.empsel.EmpSelectionModel;
import com.selima.fbi.user.IUser;
import java.io.IOException;
import java.util.Arrays;

class AddEmpRefAction
extends AbstractAddEmpRefAction {
    EmpSelectionModel selModel;

    AddEmpRefAction(MailServiceClientContext context, EmpSelectionModel selModel) {
        super(context);
        this.selModel = selModel;
    }

    @Override
    protected boolean goAheadFor(String empRef) {
        if (Arrays.asList(this.context.getCurrentUser().getEmpRef()).contains(empRef)) {
            this.selModel.select(empRef);
            return false;
        }
        return true;
    }

    @Override
    protected boolean verifyAccess(String empRef) throws CancelException, IOException {
        boolean result = this.context.getMailService().verifyAccess(empRef);
        if (result) {
            IUser user = this.context.getCurrentUser();
            user.addEmpRef(empRef);
            this.context.getUserManager().saveUser(user);
        }
        return result;
    }

    @Override
    protected void verifiedSuccessfully(String empRef) {
        this.selModel.select(empRef);
    }
}

