/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

class SimpleLayoutTraversalPolicy
extends FocusTraversalPolicy {
    SimpleLayoutTraversalPolicy() {
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        ArrayList<Component> components = this.sortedComponents(container);
        int index = Math.abs(components.indexOf(component));
        return index < components.size() - 1 ? components.get(index + 1) : null;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        ArrayList<Component> components = this.sortedComponents(container);
        int index = Math.abs(components.indexOf(component));
        return index > 0 ? components.get(index - 1) : null;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    @Override
    public Component getFirstComponent(Container container) {
        ArrayList<Component> components = this.sortedComponents(container);
        return components.size() > 0 ? components.get(0) : null;
    }

    @Override
    public Component getLastComponent(Container container) {
        ArrayList<Component> components = this.sortedComponents(container);
        return components.size() > 0 ? components.get(components.size() - 1) : null;
    }

    private ArrayList<Component> sortedComponents(Container container) {
        ArrayList<Component> components = this.components(container);
        Collections.sort(components, new LayoutComparator());
        return components;
    }

    private ArrayList<Component> components(Container container) {
        ArrayList<Component> result = new ArrayList<Component>();
        LinkedList<Container> queue = new LinkedList<Container>();
        queue.add(container);
        while (!queue.isEmpty()) {
            Container cnt = (Container)queue.remove();
            for (Component c : cnt.getComponents()) {
                if (c.isFocusable()) {
                    result.add(c);
                }
                if (!(c instanceof Container)) continue;
                queue.add((Container)c);
            }
        }
        return result;
    }

    static class LayoutComparator
    implements Comparator<Component> {
        LayoutComparator() {
        }

        @Override
        public int compare(Component o1, Component o2) {
            int result = o1.getY() - o2.getY();
            if (result == 0) {
                result = o1.getX() - o2.getX();
            }
            return result;
        }
    }
}

