/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.payebeans.IBean;
import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.ui.content.editors.IEditorProperty;
import com.selima.fbi.util.ReflectionUtil;
import com.selima.framework.util.logging.LogAPI;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ReflectiveProperty
implements IEditorProperty {
    final IBean bean;
    final String property;
    Class<?> propertyType;
    private boolean fullyResolved;
    final List<String> commonPath;
    final LinkedList<String> setterPath;
    final LinkedList<String> getterPath;
    final LinkedList<String> resetPath;

    ReflectiveProperty(IBean bean, String[] path, String property) {
        this.bean = bean;
        this.property = property;
        this.resetPath = new LinkedList();
        this.setterPath = new LinkedList();
        this.getterPath = new LinkedList();
        this.commonPath = Arrays.asList(path);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.fullyResolved) {
            this.resolveDetails();
        }
        IBean source = (IBean)ReflectionUtil.invokeGetter((Object)this.bean, Object.class, this.commonPath);
        source.addPropertyChangeListener(this.property, listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (!this.fullyResolved) {
            this.resolveDetails();
        }
        IBean source = (IBean)ReflectionUtil.invokeGetter((Object)this.bean, Object.class, this.commonPath);
        source.removePropertyChangeListener(this.property, listener);
    }

    @Override
    public Object get() {
        if (!this.fullyResolved) {
            this.resolveDetails();
        }
        return ReflectionUtil.invokeGetter((Object)this.bean, Object.class, this.getterPath);
    }

    private void resolveDetails() {
        String method;
        Object result = ReflectionUtil.invokeGetter((Object)this.bean, Object.class, this.commonPath);
        int i = 0;
        while (true) {
            switch (i) {
                case 0: {
                    method = "get" + this.upperCaseFirstLetter(this.property);
                    break;
                }
                case 1: {
                    method = "is" + this.upperCaseFirstLetter(this.property);
                    break;
                }
                default: {
                    throw new IllegalStateException("Getter for [" + this.property + "] not found in [" + result + "]");
                }
            }
            try {
                this.propertyType = result.getClass().getMethod(method, new Class[0]).getReturnType();
                break;
            }
            catch (SecurityException e) {
                throw new IllegalStateException(e);
            }
            catch (NoSuchMethodException ignored) {}
            ++i;
        }
        this.getterPath.addAll(this.commonPath);
        this.getterPath.add(method);
        try {
            String resetMethod = "reset" + this.upperCaseFirstLetter(this.property);
            result.getClass().getMethod(resetMethod, new Class[0]);
            this.resetPath.addAll(this.commonPath);
            this.resetPath.add(resetMethod);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            String setterMethod = "set" + this.upperCaseFirstLetter(this.property);
            result.getClass().getMethod(setterMethod, this.propertyType);
            this.setterPath.addAll(this.commonPath);
            this.setterPath.add(setterMethod);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.fullyResolved = true;
    }

    @Override
    public boolean isReadonly() {
        if (!this.fullyResolved) {
            this.resolveDetails();
        }
        return this.setterPath.size() == 0;
    }

    @Override
    public void set(Object value) throws PropertyValidationException {
        if (!this.fullyResolved) {
            this.resolveDetails();
        }
        try {
            ReflectionUtil.invokeSetter(this.bean, this.setterPath, this.propertyType, value);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PropertyValidationException) {
                throw (PropertyValidationException)cause;
            }
            LogAPI.logSevere((Throwable)cause);
        }
    }

    private String upperCaseFirstLetter(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public String toString() {
        return this.property + " of " + this.bean;
    }

    @Override
    public boolean isResetable() {
        if (!this.fullyResolved) {
            this.resolveDetails();
        }
        return this.resetPath.size() > 0;
    }

    @Override
    public void reset() {
        if (!this.fullyResolved) {
            this.resolveDetails();
        }
        ReflectionUtil.invokeChain(this.bean, this.resetPath, Object.class);
    }
}

