/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.ui.content.editors.IEditorProperty;
import com.selima.fbi.ui.content.editors.NumberFieldWidget;
import com.selima.fbi.ui.content.editors.NumericProperty;
import com.selima.framework.util.Util;
import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

class IntegerPartField
extends NumberFieldWidget {
    IntegerPartField(IEditorProperty property) {
        super((IEditorProperty)new IntegerPartProperty(property), new DefaultFormatterFactory(new IntegerPartNumberFormatter()));
        ((IntegerPartProperty)this.property).field = this;
        this.setHorizontalAlignment(4);
        this.getFormatter().setCommitsOnValidEdit(true);
        this.getFormatter().setValueClass(BigDecimal.class);
    }

    static class IntegerPartProperty
    extends NumericProperty {
        boolean selfChange;
        IntegerPartField field;

        IntegerPartProperty(IEditorProperty editorProperty) {
            super(editorProperty);
        }

        @Override
        Object toExternal(Object value) {
            String wholePart = value == null ? "0" : value.toString().substring(0, value.toString().indexOf(46));
            return new BigDecimal(wholePart + "." + this.fractionPartAsString(this.wrappedProperty.get()));
        }

        @Override
        Object toInternal(Object value) {
            return new BigDecimal(this.wholePartAsString(value) + ".1");
        }

        @Override
        public void set(Object value) throws PropertyValidationException {
            this.selfChange = true;
            try {
                super.set(value);
            }
            finally {
                this.selfChange = false;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            super.propertyChange(evt);
            if (!this.selfChange && !this.isReadonly() && Util.equals((Object)this.toInternal(evt.getOldValue()), (Object)this.toInternal(evt.getNewValue()))) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        field.setProperty(field.getValue());
                    }
                });
            }
        }
    }

    static class IntegerPartNumberFormatter
    extends NumberFormatter {
        IntegerPartNumberFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            if (text != null) {
                try {
                    return new BigDecimal(text + ".1");
                }
                catch (NumberFormatException e) {
                    throw new ParseException(text, text.length());
                }
            }
            return null;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value != null) {
                return value.toString().substring(0, value.toString().indexOf(46));
            }
            return null;
        }
    }
}

