/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.ui.content.editors.IEditorProperty;
import com.selima.fbi.ui.content.editors.NumberFieldWidget;
import com.selima.fbi.ui.content.editors.NumericProperty;
import com.selima.fbi.ui.content.editors.StrictDecimalFormat;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;

class FractionPartField
extends NumberFieldWidget {
    FractionPartField(IEditorProperty property) {
        this(property, new FractionFormat());
    }

    private FractionPartField(IEditorProperty property, DecimalFormat format) {
        super((IEditorProperty)new FractionProperty(property, format), format);
        this.getFormatter().setMinimum(Long.valueOf(0L));
        this.getFormatter().setMaximum(Long.valueOf(99L));
    }

    static class FractionFormat
    extends StrictDecimalFormat {
        FractionFormat() {
            super("00");
        }

        @Override
        public Object parseObject(String source) throws ParseException {
            if (source.length() == 1 && Character.isDigit(source.charAt(0))) {
                return (long)(source.charAt(0) - 48) * 10L;
            }
            return super.parseObject(source);
        }
    }

    static class FractionProperty
    extends NumericProperty {
        DecimalFormat decimalFormat;

        FractionProperty(IEditorProperty editorProperty, DecimalFormat decimalFormat) {
            super(editorProperty);
            this.decimalFormat = decimalFormat;
        }

        @Override
        Object toExternal(Object value) {
            String fractionPart = value == null ? "0" : this.decimalFormat.format(value);
            return new BigDecimal(this.wholePartAsString(this.wrappedProperty.get()) + "." + fractionPart);
        }

        @Override
        Object toInternal(Object value) {
            String string = this.fractionPartAsString(value);
            return Long.valueOf(string);
        }
    }
}

