/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.editors;

import com.selima.fbi.core.payebeans.PropertyValidationException;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.content.editors.BooleanProperty;
import com.selima.fbi.ui.content.editors.EditorWidgetSPI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public abstract class CheckBoxWidget
extends JCheckBox
implements EditorWidgetSPI,
FocusListener,
PropertyChangeListener,
ItemListener {
    protected final boolean windowsLookAndFeel;
    final BooleanProperty property;

    CheckBoxWidget(BooleanProperty property, String tooltip) {
        BasicRadioButtonUI radioUI;
        this.property = property;
        this.windowsLookAndFeel = "Windows".equals(UIManager.getLookAndFeel().getID());
        if (tooltip != null) {
            this.setToolTipText((this.windowsLookAndFeel ? "<html><p style='width:250px;padding:10px;margin:0px;'>" : "<html><p style='width:275px;padding:10px;margin:0px;font-size:small;'>") + tooltip.replaceAll("\n", "<BR>") + "</p></html>");
        }
        this.setOpaque(true);
        this.setBorderPainted(false);
        this.addFocusListener(this);
        this.setBackground(property.isReadonly() ? READONLY_BACKGROUND : DEFAULT_BACKGROUND);
        this.setEnabled(!property.isReadonly());
        if (this.getUI() instanceof BasicRadioButtonUI) {
            radioUI = (BasicRadioButtonUI)this.getUI();
        } else {
            radioUI = new BasicRadioButtonUI();
            this.setUI(radioUI);
        }
        this.setIcon(new XIcon(radioUI.getDefaultIcon()));
        CompoundBorder border = this.windowsLookAndFeel ? BorderFactory.createCompoundBorder(BorderFactory.createDashedBorder(Color.BLACK), BorderFactory.createEmptyBorder(3, 4, 4, 4)) : BorderFactory.createCompoundBorder(BorderFactory.createDashedBorder(Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 1, 2));
        this.setBorder(border);
        property.addPropertyChangeListener(this);
        this.addItemListener(this);
        this.setSelected(property.get());
    }

    @Override
    public Point preferredPopupPoint() {
        return new Point(this.getWidth() - 3, this.getHeight() - 3);
    }

    @Override
    public Action[] getPopupActions() {
        if (this.property.isResetable()) {
            return new Action[]{new ResetAction()};
        }
        return new Action[0];
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (!this.property.isReadonly()) {
            try {
                this.property.set(evt.getStateChange() == 1);
            }
            catch (PropertyValidationException e) {
                Toolkit.getDefaultToolkit().beep();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckBoxWidget.this.setSelected(CheckBoxWidget.this.property.get());
                    }
                });
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setSelected((Boolean)evt.getNewValue());
    }

    @Override
    public void setSelected(boolean state) {
        if (this.isSelected() != state) {
            super.setSelected(state);
        }
    }

    @Override
    public void detach() {
        this.property.removePropertyChangeListener(this);
    }

    @Override
    public JComponent toComponent() {
        return this;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setBorderPainted(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setBorderPainted(false);
    }

    @Override
    public Point getAdditionalOffset() {
        return this.windowsLookAndFeel ? new Point(-1, 1) : new Point(2, 2);
    }

    @Override
    public void setDivWidth(int width) {
    }

    @Override
    public boolean isResetable() {
        return this.property.isResetable();
    }

    @Override
    public void resetToPayroll() {
        this.property.reset();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.property + "]";
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            super("Reset field", SwingHelper.imageIcon("/img/16x16/actions/reset_field.png"));
            this.setEnabled(CheckBoxWidget.this.property.isResetable());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckBoxWidget.this.resetToPayroll();
        }
    }

    static class XIcon
    implements Icon {
        static JCheckBox painterCheckbox = new JCheckBox();
        Icon originalIcon;

        XIcon(Icon originalIcon) {
            this.originalIcon = originalIcon;
        }

        @Override
        public int getIconHeight() {
            return this.originalIcon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.originalIcon.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.originalIcon.paintIcon(painterCheckbox, g, x, y);
            JCheckBox realCheckBox = (JCheckBox)c;
            if (realCheckBox.isSelected()) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.BLUE);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setStroke(new BasicStroke(1.9f, 0, 0));
                g.drawLine(x + 4, y + 3, x + this.getIconWidth() - 4, y + this.getIconHeight() - 3);
                g.drawLine(x + 4, y + this.getIconHeight() - 3, x + this.getIconWidth() - 4, y + 3);
            }
        }

        static {
            painterCheckbox.setFont(painterCheckbox.getFont().deriveFont(1, 16.0f));
        }
    }
}

