/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.queue;

import com.selima.fbi.ui.content.detail.fulltext.queue.Event;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventQueue;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventQueueDecorator;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSink;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSinkDecorator;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSource;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSourceDecorator;
import com.selima.fbi.ui.content.detail.fulltext.queue.MonitoredEventQueue;
import com.selima.fbi.ui.content.detail.fulltext.queue.QueueMonitor;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultMonitoredQueue
extends EventQueueDecorator
implements MonitoredEventQueue {
    final CancelMonitor cancelMonitor = new CancelMonitor();
    final EventBroadcast<QueueMonitor> monitors = EventBroadcastFactory.createEventBroadcast(QueueMonitor.class);
    final MonitoredSink monitoredSink = new MonitoredSink(super.getSink());
    final MonitoredSource monitoredSource = new MonitoredSource(super.getSource());

    public DefaultMonitoredQueue(EventQueue eventQueue) {
        super(eventQueue);
    }

    @Override
    public EventSink getSink() {
        return this.monitoredSink;
    }

    @Override
    public EventSource getSource() {
        return this.monitoredSource;
    }

    @Override
    public void addQueueMonitor(QueueMonitor monitor) {
        this.monitors.addListener((Object)monitor);
    }

    class CancelMonitor
    implements ChangeListener {
        CancelMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent evt) {
            EventBroadcast<QueueMonitor> eventBroadcast = DefaultMonitoredQueue.this.monitors;
            synchronized (eventBroadcast) {
                Event sourceEvent = (Event)evt.getSource();
                if (sourceEvent.getCancelListeners().contains(this)) {
                    sourceEvent.removeCancelListener(this);
                    ((QueueMonitor)DefaultMonitoredQueue.this.monitors.getListener()).dequed(sourceEvent);
                }
            }
        }
    }

    class MonitoredSink
    extends EventSinkDecorator {
        MonitoredSink(EventSink wrappedSink) {
            super(wrappedSink);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Event event) {
            EventBroadcast<QueueMonitor> eventBroadcast = DefaultMonitoredQueue.this.monitors;
            synchronized (eventBroadcast) {
                ((QueueMonitor)DefaultMonitoredQueue.this.monitors.getListener()).enqued(event);
                event.addCancelListener(DefaultMonitoredQueue.this.cancelMonitor);
            }
            super.push(event);
        }
    }

    class MonitoredSource
    extends EventSourceDecorator {
        private Event lastEvent;

        MonitoredSource(EventSource wrappedSource) {
            super(wrappedSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Event pull() throws CanceledException, InterruptedException {
            EventBroadcast<QueueMonitor> eventBroadcast;
            if (this.lastEvent != null) {
                eventBroadcast = DefaultMonitoredQueue.this.monitors;
                synchronized (eventBroadcast) {
                    ((QueueMonitor)DefaultMonitoredQueue.this.monitors.getListener()).dequed(this.lastEvent);
                    this.lastEvent = null;
                }
            }
            while (true) {
                this.lastEvent = super.pull();
                eventBroadcast = DefaultMonitoredQueue.this.monitors;
                synchronized (eventBroadcast) {
                    if (this.lastEvent.getCancelListeners().contains(DefaultMonitoredQueue.this.cancelMonitor)) {
                        this.lastEvent.removeCancelListener(DefaultMonitoredQueue.this.cancelMonitor);
                        break;
                    }
                }
            }
            return this.lastEvent;
        }
    }
}

