/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.queue;

import com.selima.fbi.ui.content.detail.fulltext.queue.Event;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventQueue;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSink;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSource;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSourceDecorator;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.util.logging.LogAPI;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultEventQueue
implements EventQueue {
    boolean closed;
    final String name;
    EventSource decoratedSource;
    DefaultEventSource realSource;
    DefaultEventSink sink = new DefaultEventSink();
    Deque<Event> queue = new LinkedList<Event>();

    public DefaultEventQueue(String name) {
        this.name = name;
        this.realSource = new DefaultEventSource();
        this.decoratedSource = new LoggingEventSource(this.realSource);
    }

    @Override
    public EventSink getSink() {
        return this.sink;
    }

    @Override
    public EventSource getSource() {
        return this.decoratedSource;
    }

    @Override
    public synchronized void clear() {
        this.queue.clear();
        if (this.realSource.currentEvent != null) {
            this.realSource.currentEvent.cancel();
            this.realSource.currentEvent = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.queue) + "]";
    }

    class DefaultEventSink
    implements EventSink {
        DefaultEventSink() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Event event) {
            if (DefaultEventQueue.this.closed) {
                throw new IllegalStateException();
            }
            Deque<Event> deque = DefaultEventQueue.this.queue;
            synchronized (deque) {
                if (DefaultEventQueue.this.realSource.currentEvent != null) {
                    if (DefaultEventQueue.this.realSource.currentEvent.isSuperseededBy(event)) {
                        DefaultEventQueue.this.realSource.currentEvent.cancel();
                    } else if (event.isSuperseeding(DefaultEventQueue.this.realSource.currentEvent)) {
                        event.cancel();
                        return;
                    }
                }
                Iterator<Event> it = DefaultEventQueue.this.queue.iterator();
                while (it.hasNext()) {
                    Event enquedEvent = it.next();
                    if (enquedEvent.isSuperseededBy(event) || event.isSuperseeding(enquedEvent)) {
                        enquedEvent.cancel();
                        it.remove();
                        continue;
                    }
                    if (!event.isSuperseededBy(enquedEvent) && !enquedEvent.isSuperseeding(event)) continue;
                    event.cancel();
                    return;
                }
                DefaultEventQueue.this.queue.add(event);
                DefaultEventQueue.this.queue.notify();
            }
        }

        @Override
        public void close() {
            DefaultEventQueue.this.closed = true;
            DefaultEventQueue.this.queue.notify();
        }
    }

    class DefaultEventSource
    implements EventSource {
        Event currentEvent;

        DefaultEventSource() {
        }

        @Override
        public String getName() {
            return DefaultEventQueue.this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Event pull() throws CanceledException, InterruptedException {
            Deque<Event> deque = DefaultEventQueue.this.queue;
            synchronized (deque) {
                while (DefaultEventQueue.this.queue.isEmpty()) {
                    if (DefaultEventQueue.this.closed) {
                        throw new CanceledException("Sink closed");
                    }
                    DefaultEventQueue.this.queue.wait(3000L);
                }
                this.currentEvent = DefaultEventQueue.this.queue.pop();
                return this.currentEvent;
            }
        }
    }

    class LoggingEventSource
    extends EventSourceDecorator {
        LoggingEventSource(EventSource eventSource) {
            super(eventSource);
        }

        @Override
        public Event pull() throws CanceledException, InterruptedException {
            Event result = super.pull();
            LogAPI.logInfo((String)result.getDescription());
            return result;
        }
    }
}

