/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.queue;

import com.selima.fbi.ui.content.detail.fulltext.queue.AbstractDispatcher;
import com.selima.fbi.ui.content.detail.fulltext.queue.Event;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BackendDispatcher
extends AbstractDispatcher {
    final ISubmitter submitter;

    public BackendDispatcher(ISubmitter submitter) {
        this.submitter = submitter;
    }

    @Override
    void dispatchTemplate(Event evt) throws InterruptedException {
        final SwingOperationHandle handle = this.submitter.submitWork((BackendWork)new DispatchingWork(evt));
        evt.addCancelListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                handle.cancel();
            }
        });
        handle.waitForFinish();
    }

    class DispatchingWork
    implements BackendWork {
        final Event event;

        DispatchingWork(Event event) {
            this.event = event;
        }

        public String getName() {
            return this.event.getDescription();
        }

        public void invokeBackend(BackendOperationHandle handle) throws CanceledException, InterruptedException {
            handle.checkCancelRequest();
            BackendDispatcher.this.dispatchInCurrentThread(this.event);
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() instanceof CanceledException) {
                LogAPI.logWarning((Throwable)handle.getFailure());
            } else if (handle.getFailure() != null) {
                LogAPI.logSevere((Throwable)handle.getFailure());
            }
        }
    }
}

