/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl.lucene;

import com.selima.fbi.ui.content.detail.fulltext.impl.Index;
import com.selima.fbi.ui.content.detail.fulltext.impl.InvalidQueryException;
import com.selima.fbi.ui.content.detail.fulltext.impl.Search;
import com.selima.fbi.ui.content.detail.fulltext.impl.lucene.LuceneIndex;
import com.selima.fbi.webserver.PagePart;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;

class LuceneSearch
implements Search {
    final String queryString;
    final Query queryObject;
    static QueryParser queryParser = new QueryParser("contents", (Analyzer)new StandardAnalyzer());

    LuceneSearch(String query) throws InvalidQueryException {
        this.queryString = query;
        try {
            this.queryObject = queryParser.parse(this.queryString);
        }
        catch (ParseException e) {
            throw new InvalidQueryException(e, this.queryString);
        }
    }

    @Override
    public Set<PagePart> execute(Index index) {
        try {
            LuceneIndex luceneIndex = (LuceneIndex)index;
            IndexSearcher indexSearcher = new IndexSearcher(IndexReader.open((Directory)luceneIndex.directory));
            TopDocs topDocs = indexSearcher.search(this.queryObject, null, luceneIndex.pages.size());
            HashSet<PagePart> result = new HashSet<PagePart>();
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                int doc = topDocs.scoreDocs[i].doc;
                String partId = indexSearcher.doc(doc).get("part.id");
                result.add(luceneIndex.pages.get(partId));
            }
            return result;
        }
        catch (CorruptIndexException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getQuery() {
        return this.queryString;
    }
}

