/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl.lucene;

import com.selima.fbi.ui.content.detail.fulltext.impl.Index;
import com.selima.fbi.webserver.PagePart;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.demo.html.HTMLParser;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;

class LuceneIndex
implements Index {
    final Directory directory;
    final IndexWriter writer;
    final Map<String, PagePart> pages = new HashMap<String, PagePart>();

    LuceneIndex() {
        try {
            this.directory = new RAMDirectory();
            this.writer = new IndexWriter(this.directory, (Analyzer)new StandardAnalyzer(), true, IndexWriter.MaxFieldLength.UNLIMITED);
        }
        catch (CorruptIndexException e) {
            throw new IllegalStateException(e);
        }
        catch (LockObtainFailedException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void add(PagePart part) throws IOException {
        try {
            Document doc = new Document();
            doc.add((Fieldable)new Field("part.id", part.id, Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field("contents", new HTMLParser(part.url.openStream()).getReader()));
            this.writer.addDocument(doc);
            this.writer.commit();
            this.pages.put(part.id, part);
        }
        catch (CorruptIndexException e) {
            throw new IllegalStateException(e);
        }
    }
}

