/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl;

import com.selima.fbi.ui.common.waitdlg.AbstractProgressModel;

class SearchProgressModel
extends AbstractProgressModel {
    int currentPosition;
    int indexSize;
    int averageTime = 0;
    int indexingCount;
    long startTime = System.currentTimeMillis();
    String lastDocumentName;

    SearchProgressModel(int currentPosition, int indexSize) {
        this.currentPosition = currentPosition;
        this.indexSize = indexSize;
    }

    @Override
    public int getCurrentStep() {
        return this.currentPosition;
    }

    @Override
    public String getEventDetail() {
        if (this.lastDocumentName == null) {
            return "Indexing";
        }
        return "Indexed " + this.lastDocumentName;
    }

    @Override
    public int getNumberOfSteps() {
        return this.indexSize;
    }

    @Override
    public int getStepDuration() {
        return this.averageTime;
    }

    @Override
    public String getStepMessage() {
        return this.currentPosition + " page" + (this.currentPosition > 1 ? "s" : "") + " searched out of " + this.indexSize;
    }

    void indexedCallback(int currentPosition, String documentName) {
        this.lastDocumentName = documentName;
        if (this.currentPosition != currentPosition) {
            this.averageTime = (int)(System.currentTimeMillis() - this.startTime) / ++this.indexingCount / 1000;
            this.currentPosition = currentPosition;
            this.fireStepChange();
        } else {
            this.fireInstepChange();
        }
    }
}

