/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl;

import com.selima.fbi.ui.content.detail.fulltext.evt.ChangeEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.ChangeListener;
import com.selima.fbi.ui.content.detail.fulltext.evt.NotFoundEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.PageFoundEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.Property;
import com.selima.fbi.ui.content.detail.fulltext.evt.SearchEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.SearchEventListener;
import com.selima.fbi.ui.content.detail.fulltext.evt.SearchRequestEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.SpecificListener;
import com.selima.fbi.ui.content.detail.fulltext.impl.DefaultIndexerFactory;
import com.selima.fbi.ui.content.detail.fulltext.impl.Index;
import com.selima.fbi.ui.content.detail.fulltext.impl.Indexer;
import com.selima.fbi.ui.content.detail.fulltext.impl.IndexerFactory;
import com.selima.fbi.ui.content.detail.fulltext.impl.IndexingEvent;
import com.selima.fbi.ui.content.detail.fulltext.impl.InvalidQueryException;
import com.selima.fbi.ui.content.detail.fulltext.impl.Search;
import com.selima.fbi.ui.content.detail.fulltext.impl.SearchFactory;
import com.selima.fbi.ui.content.detail.fulltext.impl.SearchProgressModel;
import com.selima.fbi.ui.content.detail.fulltext.impl.StopSearchEvent;
import com.selima.fbi.ui.content.detail.fulltext.impl.lucene.LuceneSearchFactory;
import com.selima.fbi.ui.content.detail.fulltext.queue.ActiveEvent;
import com.selima.fbi.ui.content.detail.fulltext.queue.Event;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSink;
import com.selima.fbi.webserver.PagePart;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.util.logging.LogAPI;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SearchExecutor
extends SearchEventListener {
    final EventSink guiSink;
    final EventSink selfSink;
    String query;
    PagePart currentPage;
    PagePart lastHit;
    List<PagePart> visiblePages;
    SearchProgressModel progressModel;
    SearchFactory searchFactory = new LuceneSearchFactory();
    IndexerFactory indexerFactory = new DefaultIndexerFactory();
    SearchInitiator searchInitiator = new SearchInitiator();

    SearchExecutor(EventSink selfSink, EventSink guiSink) {
        this.selfSink = selfSink;
        this.guiSink = guiSink;
        this.addListener(new ChangeListener(){

            @Override
            public void process(ChangeEvent event) {
                SearchExecutor.this.currentPage = (PagePart)event.value;
            }
        }, Property.CURRENT_PAGE);
        this.addListener(new ChangeListener(){

            @Override
            public void process(ChangeEvent event) {
                SearchExecutor.this.query = (String)event.value;
            }
        }, Property.QUERY);
        this.addListener(new ChangeListener(){

            @Override
            public void process(ChangeEvent event) {
                SearchExecutor.this.visiblePages = (List)event.value;
            }
        }, Property.VISIBLE_PAGES);
        this.addListener(new SpecificListener<ChangeEvent>(){

            @Override
            public void process(ChangeEvent event) {
                if (event.property != Property.CURRENT_PAGE) {
                    SearchExecutor.this.lastHit = null;
                }
            }
        }, ChangeEvent.class);
        this.addListener(this.searchInitiator, SearchRequestEvent.class);
    }

    public class SearchingEvent
    extends SearchEvent
    implements ActiveEvent {
        final Indexer indexer;
        final Search search;

        SearchingEvent(Indexer indexer, Search search) {
            this.indexer = indexer;
            this.search = search;
        }

        @Override
        public String getDescription() {
            return "Searching for " + this.search.getQuery();
        }

        public String getQuery() {
            return this.search.getQuery();
        }

        @Override
        public boolean isSuperseededBy(Event event) {
            if (event instanceof ChangeEvent) {
                return true;
            }
            if (event instanceof SearchRequestEvent) {
                return true;
            }
            return event instanceof StopSearchEvent;
        }

        @Override
        public void dispatchSelf() throws CanceledException {
            Index index = this.indexer.getIndex();
            this.checkCancel();
            Set<PagePart> searchResult = this.search.execute(index);
            LogAPI.logFiner((String)"{0} hit(s) for {1} with index at {2}/{3}", (Object[])new Object[]{searchResult.size(), this.search.getQuery(), this.indexer.getCurrentIndexSize(), this.indexer.getAimedIndexSize()});
            List<PagePart> hits = Collections.emptyList();
            if (!searchResult.isEmpty()) {
                if (this.indexer.hasMoreDocuments()) {
                    TreeSet<PagePart> sorted = new TreeSet<PagePart>(new PositionComparator());
                    sorted.addAll(searchResult);
                    hits = new LinkedList<PagePart>(sorted.tailSet(SearchExecutor.this.currentPage));
                    LogAPI.logFiner((String)"{0} hit(s) following current position ", (Object)hits.size());
                    if (hits.contains(SearchExecutor.this.currentPage) && SearchExecutor.this.currentPage.equals(SearchExecutor.this.lastHit)) {
                        LogAPI.logFiner((String)"Current position is stale - removing from hits");
                        hits.remove(SearchExecutor.this.currentPage);
                    }
                } else {
                    hits = new LinkedList<PagePart>(searchResult);
                    Collections.sort(hits, new CurrentPageComparator());
                }
            }
            if (!hits.isEmpty()) {
                SearchExecutor.this.lastHit = (PagePart)hits.remove(0);
                SearchExecutor.this.guiSink.push(new PageFoundEvent(SearchExecutor.this.lastHit, this.search.getQuery()));
                if (hits.size() > 0) {
                    SearchExecutor.this.removeListener(SearchExecutor.this.searchInitiator, SearchRequestEvent.class);
                    SearchExecutor.this.addListener(new HitsListener(hits), SearchEvent.class);
                }
            } else if (this.indexer.hasMoreDocuments()) {
                this.checkCancel();
                LogAPI.logFiner((String)"Found nothing , would continue searching");
                SearchExecutor.this.selfSink.push(new IndexingEvent(this.indexer, SearchExecutor.this.selfSink));
                SearchExecutor.this.selfSink.push(new SearchingEvent(this.indexer, this.search));
            } else {
                SearchExecutor.this.guiSink.push(new NotFoundEvent(this.search.getQuery()));
            }
        }
    }

    class HitsListener
    implements SpecificListener<SearchEvent> {
        final List<PagePart> hits;

        HitsListener(List<PagePart> hits) {
            this.hits = hits;
        }

        @Override
        public void process(SearchEvent event) {
            if (event.isSearchRequestEvent()) {
                SearchExecutor.this.lastHit = this.hits.remove(0);
                SearchExecutor.this.guiSink.push(new PageFoundEvent(SearchExecutor.this.lastHit, SearchExecutor.this.query));
            }
            if (this.hits.isEmpty() || event.isChangeEvent() && event.asChangeEvent().property != Property.CURRENT_PAGE) {
                SearchExecutor.this.removeListener(this, SearchEvent.class);
                SearchExecutor.this.addListener(SearchExecutor.this.searchInitiator, SearchRequestEvent.class);
            }
        }
    }

    class CurrentPageComparator
    implements Comparator<PagePart> {
        int startingIndex;

        public CurrentPageComparator() {
            this.startingIndex = SearchExecutor.this.visiblePages.indexOf(SearchExecutor.this.currentPage);
            if (SearchExecutor.this.lastHit == SearchExecutor.this.currentPage) {
                ++this.startingIndex;
            }
        }

        @Override
        public int compare(PagePart o1, PagePart o2) {
            return this.distanceFromCurrentPage(o1) - this.distanceFromCurrentPage(o2);
        }

        int distanceFromCurrentPage(PagePart page) {
            int result = SearchExecutor.this.visiblePages.indexOf(page) - this.startingIndex;
            if (result < 0) {
                result += SearchExecutor.this.visiblePages.size();
            }
            return result;
        }
    }

    class PositionComparator
    implements Comparator<PagePart> {
        PositionComparator() {
        }

        @Override
        public int compare(PagePart o1, PagePart o2) {
            return SearchExecutor.this.visiblePages.indexOf(o1) - SearchExecutor.this.visiblePages.indexOf(o2);
        }
    }

    class SearchInitiator
    implements SpecificListener<SearchRequestEvent> {
        SearchInitiator() {
        }

        @Override
        public void process(SearchRequestEvent event) {
            Indexer indexer = SearchExecutor.this.indexerFactory.create(SearchExecutor.this.visiblePages);
            if (indexer.hasMoreDocuments()) {
                SearchExecutor.this.selfSink.push(new IndexingEvent(indexer, SearchExecutor.this.selfSink));
            }
            try {
                SearchExecutor.this.selfSink.push(new SearchingEvent(indexer, SearchExecutor.this.searchFactory.create(SearchExecutor.this.query)));
            }
            catch (InvalidQueryException e) {
                LogAPI.logWarning((Throwable)e);
            }
        }
    }
}

