/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl;

import com.selima.fbi.ui.content.detail.fulltext.evt.HideProgressBarEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.ShowProgressBarEvent;
import com.selima.fbi.ui.content.detail.fulltext.impl.IndexNotification;
import com.selima.fbi.ui.content.detail.fulltext.impl.IndexingEvent;
import com.selima.fbi.ui.content.detail.fulltext.impl.SearchExecutor;
import com.selima.fbi.ui.content.detail.fulltext.impl.SearchInterrupter;
import com.selima.fbi.ui.content.detail.fulltext.impl.SearchProgressModel;
import com.selima.fbi.ui.content.detail.fulltext.queue.Event;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventSink;
import com.selima.fbi.ui.content.detail.fulltext.queue.QueueMonitor;

class ProgressBarMonitor
implements QueueMonitor {
    final EventSink guiSink;
    final EventSink backendSink;
    SearchProgressModel progressModel;
    int numOfSearchEvents;

    ProgressBarMonitor(EventSink guiSink, EventSink backendSink) {
        this.backendSink = backendSink;
        this.guiSink = guiSink;
    }

    @Override
    public void dequed(Event event) {
        if (event instanceof SearchExecutor.SearchingEvent) {
            if (--this.numOfSearchEvents == 0 && this.progressModel != null) {
                this.progressModel = null;
                this.guiSink.push(new HideProgressBarEvent());
            }
        } else if (event instanceof IndexingEvent) {
            IndexingEvent indexEvent = (IndexingEvent)event;
            if (this.progressModel != null && !event.isCanceled()) {
                this.guiSink.push(new IndexNotification(this.progressModel, indexEvent.names, indexEvent.indexer.getCurrentIndexSize()));
            }
        }
    }

    @Override
    public void enqued(Event event) {
        if (event instanceof SearchExecutor.SearchingEvent) {
            SearchExecutor.SearchingEvent searchEvent = (SearchExecutor.SearchingEvent)event;
            ++this.numOfSearchEvents;
            if (this.progressModel == null && searchEvent.indexer.hasMoreDocuments()) {
                this.progressModel = new SearchProgressModel(searchEvent.indexer.getCurrentIndexSize(), searchEvent.indexer.getAimedIndexSize());
                this.guiSink.push(new ShowProgressBarEvent(this.progressModel, new SearchInterrupter(this.backendSink)));
            }
        }
    }
}

