/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl;

import com.selima.fbi.ui.content.detail.fulltext.SearchContext;
import com.selima.fbi.ui.content.detail.fulltext.SearchEngine;
import com.selima.fbi.ui.content.detail.fulltext.impl.ProgressBarMonitor;
import com.selima.fbi.ui.content.detail.fulltext.impl.SearchController;
import com.selima.fbi.ui.content.detail.fulltext.impl.SearchExecutor;
import com.selima.fbi.ui.content.detail.fulltext.impl.SearchResponder;
import com.selima.fbi.ui.content.detail.fulltext.queue.BackendDispatcher;
import com.selima.fbi.ui.content.detail.fulltext.queue.DefaultEventQueue;
import com.selima.fbi.ui.content.detail.fulltext.queue.DefaultMonitoredQueue;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventDispatcher;
import com.selima.fbi.ui.content.detail.fulltext.queue.MonitoredEventQueue;
import com.selima.fbi.ui.content.detail.fulltext.queue.SwingDispatcher;

public class DefaultSearchEngine
implements SearchEngine {
    final EventDispatcher frontendDispatcher;
    final EventDispatcher backendDispatcher;
    final MonitoredEventQueue backendQueue;
    final MonitoredEventQueue frontendQueue;
    final SearchController searchController;
    final SearchResponder searchResponder;
    final SearchExecutor searchExecutor;
    final SearchContext searchContext;

    public DefaultSearchEngine(SearchContext searchContext) {
        this.searchContext = searchContext;
        this.frontendQueue = new DefaultMonitoredQueue(new DefaultEventQueue("Search Response"));
        this.backendQueue = new DefaultMonitoredQueue(new DefaultEventQueue("Search Request"));
        this.searchController = new SearchController(searchContext, this.backendQueue.getSink());
        this.searchExecutor = new SearchExecutor(this.backendQueue.getSink(), this.frontendQueue.getSink());
        this.searchResponder = new SearchResponder(searchContext);
        this.frontendDispatcher = new SwingDispatcher();
        this.frontendDispatcher.setSource(this.frontendQueue.getSource());
        this.frontendDispatcher.addListener(this.searchResponder);
        this.backendDispatcher = new BackendDispatcher(searchContext.getSubmitter());
        this.backendDispatcher.setSource(this.backendQueue.getSource());
        this.backendDispatcher.addListener(this.searchExecutor);
        this.backendQueue.addQueueMonitor(new ProgressBarMonitor(this.frontendQueue.getSink(), this.backendQueue.getSink()));
    }

    @Override
    public void search() {
        this.searchController.search();
    }

    @Override
    public void start() {
        this.searchController.start();
        this.backendDispatcher.start();
        this.frontendDispatcher.start();
    }

    @Override
    public void stop() {
        this.searchController.stop();
        this.frontendDispatcher.stop();
        this.backendDispatcher.stop();
        this.frontendQueue.clear();
        this.backendQueue.clear();
    }
}

