/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.impl;

import com.selima.fbi.ui.content.detail.fulltext.impl.Index;
import com.selima.fbi.ui.content.detail.fulltext.impl.Indexer;
import com.selima.fbi.webserver.PagePart;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class DefaultIndexer
implements Indexer {
    final List<PagePart> pages;
    final LinkedList<PagePart> queue;
    final Index index;
    boolean failed;

    DefaultIndexer(Index index, List<PagePart> pages) {
        this.queue = new LinkedList<PagePart>(pages);
        this.index = index;
        this.pages = pages;
    }

    @Override
    public int getAimedIndexSize() {
        return this.pages.size();
    }

    @Override
    public int getCurrentIndexSize() {
        return this.pages.size() - this.queue.size();
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public List<String> nextDocumentNames(int numOfDocs) {
        LinkedList<String> result = new LinkedList<String>();
        ListIterator iterator = this.queue.listIterator();
        while (iterator.hasNext() && iterator.nextIndex() < numOfDocs) {
            result.add(((PagePart)iterator.next()).getName());
        }
        return result;
    }

    @Override
    public boolean hasMoreDocuments() {
        return !this.failed && !this.queue.isEmpty();
    }

    @Override
    public void indexNextDocument() {
        try {
            this.index.add(this.queue.peek());
            this.queue.remove();
        }
        catch (IOException e) {
            this.failed = true;
            LogAPI.logSevere((Throwable)e);
        }
    }
}

