/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail.fulltext.evt;

import com.selima.fbi.ui.content.detail.fulltext.evt.ChangeEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.Property;
import com.selima.fbi.ui.content.detail.fulltext.evt.SearchEvent;
import com.selima.fbi.ui.content.detail.fulltext.evt.SpecificListener;
import com.selima.fbi.ui.content.detail.fulltext.queue.Event;
import com.selima.fbi.ui.content.detail.fulltext.queue.EventListener;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;

public class SearchEventListener
implements EventListener {
    EventBroadcast<EventListener> listeners = EventBroadcastFactory.createEventBroadcast(EventListener.class);

    public <EventType extends SearchEvent> void addListener(SpecificListener<EventType> listener, Class<EventType> eventType) {
        this.listeners.addListener(new EventFilter<EventType>(listener, eventType));
    }

    public void addListener(SpecificListener<ChangeEvent> listener, Property property) {
        this.listeners.addListener((Object)new ChangeEventFilter(listener, property));
    }

    public void removeListener(SpecificListener<ChangeEvent> listener, Property property) {
        this.listeners.removeListener((Object)new ChangeEventFilter(listener, property));
    }

    public <EventType extends SearchEvent> void removeListener(SpecificListener<EventType> listener, Class<EventType> eventType) {
        this.listeners.removeListener(new EventFilter<EventType>(listener, eventType));
    }

    @Override
    public void process(Event event) throws CanceledException {
        ((EventListener)this.listeners.getListener()).process(event);
    }

    static class EventFilter<EventType extends SearchEvent>
    implements EventListener {
        final Class<EventType> eventType;
        final SpecificListener<EventType> listener;

        EventFilter(SpecificListener<EventType> listener, Class<EventType> eventType) {
            this.eventType = eventType;
            this.listener = listener;
        }

        @Override
        public void process(Event event) throws CanceledException {
            if (this.eventType.isInstance(event)) {
                this.listener.process((SearchEvent)this.eventType.cast(event));
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof EventFilter) {
                EventFilter filter = (EventFilter)obj;
                return filter.listener.equals(this.listener) && filter.eventType.equals(this.eventType);
            }
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode() + this.eventType.hashCode();
        }
    }

    static class ChangeEventFilter
    extends EventFilter<ChangeEvent> {
        ChangeEventFilter(SpecificListener<ChangeEvent> listener, Property property) {
            super(new PropertyFilter(listener, property), ChangeEvent.class);
        }

        static class PropertyFilter
        implements SpecificListener<ChangeEvent> {
            final SpecificListener<ChangeEvent> listener;
            final Property property;

            public PropertyFilter(SpecificListener<ChangeEvent> listener, Property property) {
                this.property = property;
                this.listener = listener;
            }

            @Override
            public void process(ChangeEvent event) {
                if (event.property == this.property) {
                    this.listener.process(event);
                }
            }

            public boolean equals(Object obj) {
                if (obj instanceof PropertyFilter) {
                    PropertyFilter other = (PropertyFilter)obj;
                    return other.listener.equals(this.listener) && other.property.equals((Object)this.property);
                }
                return super.equals(obj);
            }

            public int hashCode() {
                return this.listener.hashCode() + this.property.hashCode();
            }
        }
    }
}

