/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.ui.content.detail.BrowserTabComponent;
import com.selima.fbi.ui.content.detail.BrowserTabbedPane;
import com.selima.fbi.ui.content.detail.MessageBrowserContext;
import com.selima.fbi.ui.content.detail.TabbedPaneSelectionModel;
import com.selima.fbi.ui.content.detail.TabbedPaneSelectionModelContext;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.webserver.PagePart;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

class OuterTabbedPane
extends JTabbedPane
implements TabbedPaneSelectionModelContext {
    LinkedList<IntermediateTabContainer> recentTabs = new LinkedList();
    final MessageBrowserContext clientContext;

    OuterTabbedPane(MessageBrowserContext clientContext, BrowserTabbedPane tabbedPane) {
        super(4, 1);
        this.clientContext = clientContext;
        this.setModel(new TabbedPaneSelectionModel(this));
        IntermediateTabContainer tabContainer = new IntermediateTabContainer(tabbedPane);
        this.addTab(tabContainer.getTabName(), null, tabContainer, tabContainer.getToolTipText());
    }

    void highlight(String text, PagePart pagePart) {
        int max = this.getTabCount();
        for (int i = 0; i < max; ++i) {
            IntermediateTabContainer tabContainer = this.intermediateTabContainerAt(i);
            if (tabContainer.pageParts.contains(pagePart)) {
                tabContainer.highlight(text, pagePart);
                this.setSelectedIndex(i);
                continue;
            }
            tabContainer.highlight(null, null);
        }
    }

    void resetFieldToPayroll() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            this.intermediateTabContainerAt(index).resetFieldToPayroll();
        }
    }

    void resetPageToPayroll() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            this.intermediateTabContainerAt(index).resetPageToPayroll();
        }
    }

    void navigateBack() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            this.intermediateTabContainerAt(index).navigateBack();
        }
    }

    public BrowserTabComponent getSelectedTab() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            IntermediateTabContainer tabContainer = this.intermediateTabContainerAt(index);
            if (tabContainer.browserTabbedPane != null) {
                return tabContainer.browserTabbedPane.getSelectedComponent();
            }
        }
        return null;
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public URL getCurrentURL() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            return this.intermediateTabContainerAt(index).getCurrentURL();
        }
        return null;
    }

    @Override
    public PagePart getCurrentPage() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            return this.intermediateTabContainerAt(index).getCurrentPage();
        }
        return null;
    }

    @Override
    public PrintingDetails getPrintingDetails() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            return this.intermediateTabContainerAt(index).getPrintingDetails();
        }
        return null;
    }

    @Override
    public boolean isBackEnabled() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            return this.intermediateTabContainerAt(index).isBackEnabled();
        }
        return false;
    }

    @Override
    public boolean isFieldResetable() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            return this.intermediateTabContainerAt(index).isFieldResetable();
        }
        return false;
    }

    @Override
    public boolean isPageResetable() {
        int index = this.getSelectedIndex();
        if (index >= 0 && index < this.getTabCount()) {
            return this.intermediateTabContainerAt(index).isPageResetable();
        }
        return false;
    }

    void addTab(PagePart pagePart) {
        IntermediateTabContainer tabContainer = this.intermediateTabContainerAt(this.getTabCount() - 1);
        if (tabContainer.isFull()) {
            tabContainer = new IntermediateTabContainer(pagePart);
            this.addTab(tabContainer.getTabName(), tabContainer);
        } else {
            tabContainer.addTab(pagePart);
        }
    }

    private IntermediateTabContainer intermediateTabContainerAt(int i) {
        return (IntermediateTabContainer)this.getComponentAt(i);
    }

    @Override
    public void updateUI() {
        Object oldInsets = UIManager.get("TabbedPane.contentBorderInsets");
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 0, 0, 0));
        try {
            super.updateUI();
        }
        finally {
            UIManager.put("TabbedPane.contentBorderInsets", oldInsets);
        }
    }

    public void setSelectedTab(PagePart pagePart) {
        int max = this.getTabCount();
        for (int i = 0; i < max; ++i) {
            IntermediateTabContainer tabContainer = this.intermediateTabContainerAt(i);
            if (!tabContainer.pageParts.contains(pagePart)) continue;
            int indexToSelect = i;
            this.setSelectedIndex(indexToSelect);
            if (tabContainer.browserTabbedPane != null) {
                tabContainer.browserTabbedPane.setSelectedTab(pagePart);
                break;
            }
            tabContainer.selectedPart = pagePart;
            break;
        }
    }

    void recycle() {
        int max = this.getTabCount();
        for (int i = 0; i < max; ++i) {
            this.intermediateTabContainerAt(i).recycle();
        }
    }

    class IntermediateTabContainer
    extends JPanel
    implements ComponentListener,
    PropertyChangeListener {
        BrowserTabbedPane browserTabbedPane;
        PagePart selectedPart;
        List<PagePart> pageParts;
        PagePart highlightedPart;
        String highlightedWords;

        private IntermediateTabContainer() {
            super(new GridLayout(1, 1));
            this.addComponentListener(this);
            this.setOpaque(true);
            this.setBackground(Color.WHITE);
        }

        IntermediateTabContainer(BrowserTabbedPane tabbedPane) {
            this();
            this.browserTabbedPane = tabbedPane;
            this.pageParts = this.browserTabbedPane.getPageParts();
            this.add(this.browserTabbedPane);
            this.browserTabbedPane.addPropertyChangeListener(this);
        }

        IntermediateTabContainer(PagePart pagePart) {
            this();
            this.pageParts = new ArrayList<PagePart>(this$0.clientContext.getTabLimit());
            this.pageParts.add(pagePart);
        }

        void highlight(String text, PagePart pagePart) {
            this.highlightedPart = pagePart;
            this.highlightedWords = text;
            if (this.browserTabbedPane != null) {
                this.browserTabbedPane.highlight(text, pagePart);
            }
        }

        void resetFieldToPayroll() {
            if (this.browserTabbedPane != null) {
                this.browserTabbedPane.resetFieldToPayroll();
            }
        }

        void resetPageToPayroll() {
            if (this.browserTabbedPane != null) {
                this.browserTabbedPane.resetPageToPayroll();
            }
        }

        void navigateBack() {
            if (this.browserTabbedPane != null) {
                this.browserTabbedPane.navigateBack();
            }
        }

        void addTab(PagePart pagePart) {
            int tabIndex;
            assert (!this.isFull());
            this.pageParts.add(pagePart);
            if (this.browserTabbedPane != null) {
                this.browserTabbedPane.addTab(pagePart);
            }
            if ((tabIndex = this.getCurrentTabIndex()) != -1) {
                OuterTabbedPane.this.setTitleAt(tabIndex, this.getTabName());
                OuterTabbedPane.this.setToolTipTextAt(tabIndex, this.getToolTipText());
            }
        }

        @Override
        public String getToolTipText() {
            StringBuilder result = new StringBuilder("<html><div style='text-align:center'>");
            if (this.pageParts.size() > 0) {
                result.append(this.pageParts.get(0).getName());
            }
            if (this.pageParts.size() > 1) {
                result.append("<br> to <br>").append(this.pageParts.get(this.pageParts.size() - 1).getName());
            }
            result.append("</div></html>");
            return result.toString();
        }

        PrintingDetails getPrintingDetails() {
            return this.browserTabbedPane != null ? this.browserTabbedPane.getPrintingDetails() : null;
        }

        URL getCurrentURL() {
            return this.browserTabbedPane != null ? this.browserTabbedPane.getCurrentURL() : null;
        }

        PagePart getCurrentPage() {
            return this.browserTabbedPane != null ? this.browserTabbedPane.getCurrentPage() : null;
        }

        boolean isBackEnabled() {
            return this.browserTabbedPane != null && this.browserTabbedPane.isBackEnabled();
        }

        boolean isFieldResetable() {
            return this.browserTabbedPane != null && this.browserTabbedPane.isFieldResetable();
        }

        boolean isPageResetable() {
            return this.browserTabbedPane != null && this.browserTabbedPane.isPageResetable();
        }

        boolean isFull() {
            return this.pageParts.size() >= OuterTabbedPane.this.clientContext.getTabLimit();
        }

        String getTabName() {
            int tabIndex = this.getCurrentTabIndex();
            int firstPage = this.getNumberOfPagesUpTo(tabIndex == -1 ? OuterTabbedPane.this.getTabCount() : tabIndex);
            return firstPage + 1 + " to " + (firstPage + this.pageParts.size());
        }

        int getCurrentTabIndex() {
            for (int i = 0; i < OuterTabbedPane.this.getTabCount(); ++i) {
                if (OuterTabbedPane.this.getComponentAt(i) != this) continue;
                return i;
            }
            return -1;
        }

        int getNumberOfPagesUpTo(int index) {
            int page = 0;
            for (int i = 0; i < index; ++i) {
                page += ((OuterTabbedPane)OuterTabbedPane.this).intermediateTabContainerAt((int)i).pageParts.size();
            }
            return page;
        }

        void recycle() {
            if (this.browserTabbedPane != null) {
                this.selectedPart = this.browserTabbedPane.getSelectedComponent() != null ? this.browserTabbedPane.getSelectedComponent().pagePart : null;
                this.browserTabbedPane.recycle();
                this.remove(this.browserTabbedPane);
                this.browserTabbedPane = null;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (this.browserTabbedPane != null) {
                OuterTabbedPane.this.recentTabs.remove(this);
                OuterTabbedPane.this.recentTabs.addFirst(this);
                if (OuterTabbedPane.this.recentTabs.size() > 4) {
                    OuterTabbedPane.this.recentTabs.removeLast().recycle();
                }
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (this.browserTabbedPane == null && OuterTabbedPane.this.getSelectedIndex() == this.getCurrentTabIndex()) {
                this.browserTabbedPane = new BrowserTabbedPane(OuterTabbedPane.this.clientContext);
                URL formerURL = this.getCurrentURL();
                PagePart formerPage = this.getCurrentPage();
                boolean wasBackEnabled = this.isBackEnabled();
                boolean wasPageResetable = this.isPageResetable();
                boolean wasFieldResetable = this.isFieldResetable();
                PrintingDetails formerPrintingDetails = this.getPrintingDetails();
                this.add(this.browserTabbedPane);
                for (PagePart part : this.pageParts) {
                    this.browserTabbedPane.addTab(part);
                    if (this.highlightedPart != null) {
                        if (!this.highlightedPart.equals(part)) continue;
                        this.browserTabbedPane.highlight(this.highlightedWords, this.highlightedPart);
                        continue;
                    }
                    if (this.selectedPart == null || !this.selectedPart.equals(part)) continue;
                    this.browserTabbedPane.setSelectedTab(part);
                    this.selectedPart = null;
                }
                this.firePropertyChange("backEnabled", wasBackEnabled, this.isBackEnabled());
                this.firePropertyChange("fieldResetable", wasFieldResetable, this.isFieldResetable());
                this.firePropertyChange("pageResetable", wasPageResetable, this.isPageResetable());
                this.firePropertyChange("currentURL", formerURL, this.getCurrentURL());
                this.firePropertyChange("printingDetails", formerPrintingDetails, this.getPrintingDetails());
                this.firePropertyChange("currentPage", formerPage, this.getCurrentPage());
                this.browserTabbedPane.addPropertyChangeListener("backEnabled", this);
                this.browserTabbedPane.addPropertyChangeListener("fieldResetable", this);
                this.browserTabbedPane.addPropertyChangeListener("pageResetable", this);
                this.browserTabbedPane.addPropertyChangeListener("currentURL", this);
                this.browserTabbedPane.addPropertyChangeListener("printingDetails", this);
                this.browserTabbedPane.addPropertyChangeListener("currentPage", this);
            }
        }

        @Override
        public String toString() {
            return this.getTabName();
        }
    }
}

