/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.CancelException;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.waitdlg.MailServiceInterrupter;
import com.selima.fbi.ui.content.MessageBoxContent;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class DeleteAction<MessageType extends IMailMessage>
extends AbstractAction {
    final MessageBoxContent<MessageType> messagesContent;
    final MailServiceClientContext clientContext;
    final MessageType message;

    DeleteAction(MailServiceClientContext clientContext, MessageType message, MessageBoxContent<MessageType> messagesContent) {
        super("Delete", SwingHelper.imageIcon("/img/16x16/actions/mail_delete.png"));
        this.messagesContent = messagesContent;
        this.clientContext = clientContext;
        this.message = message;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int answer = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor((Component)evt.getSource()), this.createWarningMessage(), this.clientContext.getTitle(), 0, 3);
        if (answer == 0) {
            this.clientContext.getSubmitter().submitWork(new BackendWork(){

                public String getName() {
                    return "Deleting message '" + DeleteAction.this.message.getSubject() + "'";
                }

                public void invokeSwing(SwingOperationHandle handle) {
                    if (handle.getFailure() == null) {
                        DeleteAction.this.messagesContent.hideMessage(DeleteAction.this.message);
                        DeleteAction.this.clientContext.displayContent(DeleteAction.this.messagesContent);
                    } else if (!(handle.getFailure() instanceof CanceledException)) {
                        FailureDialog.show(DeleteAction.this.clientContext.getTitle(), "<b>Failed to delete message</b>", handle.getFailure());
                        LogAPI.logSevere((Throwable)handle.getFailure());
                    }
                }

                public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
                    DeleteAction.this.clientContext.getStatusBar().setInterrupter(new MailServiceInterrupter(DeleteAction.this.clientContext.getMailService()));
                    try {
                        DeleteAction.this.clientContext.getMailService().deleteMessages(DeleteAction.this.messagesContent.getFolder(), DeleteAction.this.message.getStoreId());
                    }
                    catch (IOException e) {
                        handle.setFailure((Throwable)e);
                    }
                    catch (CancelException e) {
                        throw new CanceledException((Exception)e);
                    }
                    finally {
                        DeleteAction.this.clientContext.getStatusBar().setInterrupter(null);
                    }
                }
            });
        }
    }

    protected CharSequence createWarningMessage() {
        return "Do you want to delete the message?";
    }
}

