/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.ui.content.detail.BrowserTabComponent;
import com.selima.fbi.ui.content.detail.MessageBrowserContext;
import com.selima.fbi.ui.content.detail.TabbedPaneSelectionModel;
import com.selima.fbi.ui.content.detail.TabbedPaneSelectionModelContext;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.webserver.PagePart;
import java.awt.Color;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class BrowserTabbedPane
extends JTabbedPane
implements TabbedPaneSelectionModelContext {
    final LinkedList<BrowserTabComponent> lastUsedTabs = new LinkedList();
    final MessageBrowserContext clientContext;

    BrowserTabbedPane(MessageBrowserContext clientContext) {
        super(3, 0);
        this.clientContext = clientContext;
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setModel(new TabbedPaneSelectionModel(this));
        new WebBrowserReclaimer().attach();
    }

    @Override
    public void updateUI() {
        Object oldInsets = UIManager.get("TabbedPane.contentBorderInsets");
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(1, 0, 0, 0));
        try {
            super.updateUI();
        }
        finally {
            UIManager.put("TabbedPane.contentBorderInsets", oldInsets);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public boolean isFull() {
        return this.getTabCount() >= this.clientContext.getTabLimit();
    }

    public List<PagePart> getPageParts() {
        ArrayList<PagePart> result = new ArrayList<PagePart>(this.getTabCount());
        int max = this.getTabCount();
        for (int i = 0; i < max; ++i) {
            BrowserTabComponent tabComponent = this.getComponentAt(i);
            result.add(tabComponent.pagePart);
        }
        return result;
    }

    public void addTab(PagePart pagePart) {
        assert (!this.isFull()) : "This tabbed pane is already full";
        this.addTab(pagePart.getName(), new BrowserTabComponent(this.clientContext, pagePart));
    }

    void addTab(BrowserTabComponent tab) {
        assert (!this.isFull()) : "This tabbed pane is already full";
        this.addTab(tab.pagePart.getName(), tab);
    }

    @Override
    public boolean isBackEnabled() {
        BrowserTabComponent selectedComponent = this.getSelectedComponent();
        return selectedComponent != null && selectedComponent.isBackEnabled();
    }

    public void navigateBack() {
        BrowserTabComponent selectedComponent = this.getSelectedComponent();
        selectedComponent.navigateBack();
    }

    @Override
    public boolean isPageResetable() {
        BrowserTabComponent selectedComponent = this.getSelectedComponent();
        return selectedComponent != null && selectedComponent.isPageResetable();
    }

    public void resetPageToPayroll() {
        BrowserTabComponent selectedComponent = this.getSelectedComponent();
        selectedComponent.resetPageToPayroll();
    }

    @Override
    public boolean isFieldResetable() {
        BrowserTabComponent selectedComponent = this.getSelectedComponent();
        return selectedComponent != null && selectedComponent.isFieldResetable();
    }

    public void resetFieldToPayroll() {
        BrowserTabComponent selectedComponent = this.getSelectedComponent();
        selectedComponent.resetFieldToPayroll();
    }

    @Override
    public URL getCurrentURL() {
        BrowserTabComponent selectedComponent = this.getSelectedComponent();
        if (selectedComponent != null) {
            return selectedComponent.getCurrentURL();
        }
        return null;
    }

    @Override
    public PrintingDetails getPrintingDetails() {
        BrowserTabComponent selectedComponent = this.getSelectedComponent();
        if (selectedComponent != null) {
            return selectedComponent.getPrintingDetails();
        }
        return null;
    }

    @Override
    public BrowserTabComponent getSelectedComponent() {
        return (BrowserTabComponent)super.getSelectedComponent();
    }

    @Override
    public PagePart getCurrentPage() {
        BrowserTabComponent selectedTab = this.getSelectedComponent();
        return selectedTab != null ? selectedTab.pagePart : null;
    }

    void highlight(String text, PagePart pagePart) {
        int max = this.getTabCount();
        for (int i = 0; i < max; ++i) {
            BrowserTabComponent tabComponent = this.getComponentAt(i);
            if (tabComponent.pagePart.equals(pagePart)) {
                tabComponent.highlight(text);
                this.setSelectedIndex(i);
                continue;
            }
            tabComponent.highlight(null);
        }
    }

    void setSelectedTab(PagePart pagePart) {
        int max = this.getTabCount();
        for (int i = 0; i < max; ++i) {
            BrowserTabComponent tabComponent = this.getComponentAt(i);
            if (!tabComponent.pagePart.equals(pagePart)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    void recycle() {
        while (!this.lastUsedTabs.isEmpty()) {
            this.lastUsedTabs.removeLast().releaseMessageBrowser();
        }
    }

    @Override
    public BrowserTabComponent getComponentAt(int index) {
        return (BrowserTabComponent)super.getComponentAt(index);
    }

    class WebBrowserReclaimer
    implements ChangeListener {
        WebBrowserReclaimer() {
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            BrowserTabComponent currentTab = BrowserTabbedPane.this.getSelectedComponent();
            BrowserTabbedPane.this.lastUsedTabs.remove(currentTab);
            BrowserTabbedPane.this.lastUsedTabs.addFirst(currentTab);
            if (BrowserTabbedPane.this.lastUsedTabs.size() > 5) {
                BrowserTabbedPane.this.lastUsedTabs.removeLast().releaseMessageBrowser();
            }
        }

        void attach() {
            BrowserTabbedPane.this.addChangeListener(this);
        }
    }
}

