/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.ui.content.detail.MessageBrowserContext;
import com.selima.fbi.ui.content.editors.MessageBrowser;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.webserver.PagePart;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.SwingOperationHandle;
import java.awt.Color;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class BrowserTabComponent
extends JPanel
implements AncestorListener,
PropertyChangeListener {
    MessageBrowser messageBrowser;
    String highlightedWords;
    final PagePart pagePart;
    final MessageBrowserContext clientContext;

    BrowserTabComponent(MessageBrowserContext clientContext, PagePart pagePart) {
        super(null);
        this.pagePart = pagePart;
        this.clientContext = clientContext;
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.addAncestorListener(this);
    }

    public URL getCurrentURL() {
        URL result = null;
        if (this.messageBrowser != null) {
            result = this.messageBrowser.getHtmlURL();
        }
        if (result == null) {
            result = this.pagePart.url;
        }
        return result;
    }

    public PrintingDetails getPrintingDetails() {
        if (this.messageBrowser != null) {
            return this.messageBrowser.getPrintingDetails();
        }
        return null;
    }

    public boolean isBackEnabled() {
        return this.messageBrowser != null && this.messageBrowser.isBackEnabled();
    }

    public boolean isFieldResetable() {
        return this.messageBrowser != null && this.messageBrowser.isFieldResetable();
    }

    public void resetFieldToPayroll() {
        assert (this.isFieldResetable());
        this.messageBrowser.resetFieldToPayroll();
    }

    public boolean isPageResetable() {
        return this.messageBrowser != null && this.messageBrowser.isPageResetable();
    }

    public void resetPageToPayroll() {
        assert (this.isPageResetable());
        this.messageBrowser.resetPageToPayroll();
    }

    public void navigateBack() {
        assert (this.isBackEnabled());
        this.messageBrowser.navigateBack();
    }

    @Override
    public void doLayout() {
        if (this.getComponentCount() == 1) {
            this.getComponent(0).setBounds(0, 0, this.getWidth(), this.getHeight());
            this.getComponent(0).doLayout();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        boolean displayable = true;
        Container container = this.getParent();
        if (container instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)container;
            boolean bl = displayable = tabbedPane.getSelectedComponent() == this;
        }
        if (displayable && this.messageBrowser == null) {
            this.messageBrowser = this.clientContext.createMessageBrowser();
            this.add(this.messageBrowser);
            this.messageBrowser.addPropertyChangeListener("htmlURL", this);
            this.messageBrowser.addPropertyChangeListener("backEnabled", this);
            this.messageBrowser.addPropertyChangeListener("printingDetails", this);
            this.messageBrowser.addPropertyChangeListener("fieldResetable", this);
            this.messageBrowser.addPropertyChangeListener("pageResetable", this);
            this.doLayout();
            this.clientContext.getSubmitter().submitWork(new BackendWork(){

                public String getName() {
                    return "Loading '" + BrowserTabComponent.this.pagePart.getName() + "'";
                }

                public void invokeBackend(BackendOperationHandle handle) {
                    MessageBrowser usedBrowser = BrowserTabComponent.this.messageBrowser;
                    if (usedBrowser != null) {
                        usedBrowser.setPagePart(BrowserTabComponent.this.pagePart);
                        usedBrowser.setSubmitter(BrowserTabComponent.this.clientContext.getSubmitter());
                        usedBrowser.highlight(BrowserTabComponent.this.highlightedWords);
                    }
                }

                public void invokeSwing(SwingOperationHandle handle) {
                    BrowserTabComponent.this.clientContext.getStatusBar().displayMessage("Loaded '" + BrowserTabComponent.this.pagePart.getName() + "'");
                }
            });
            this.clientContext.getStatusBar().displayMessage("Loading '" + this.pagePart.getName() + "'");
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    public void releaseMessageBrowser() {
        this.removeAll();
        if (this.messageBrowser != null) {
            this.messageBrowser.detach();
            this.messageBrowser = null;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.messageBrowser) {
            String name = evt.getPropertyName();
            if ("htmlURL".equals(name)) {
                name = "currentURL";
            }
            this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
        }
    }

    void highlight(String text) {
        if (this.messageBrowser != null) {
            this.messageBrowser.highlight(text);
        } else {
            this.highlightedWords = text;
        }
    }
}

