/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.detail;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.content.AbstractClientContent;
import com.selima.fbi.ui.content.detail.BrowserTabComponent;
import com.selima.fbi.ui.content.detail.BrowserTabbedPane;
import com.selima.fbi.ui.content.detail.DefaultMessageBrowserContext;
import com.selima.fbi.ui.content.detail.OuterTabbedPane;
import com.selima.fbi.ui.content.html.PrintingDetails;
import com.selima.fbi.ui.content.html.SinglePagePortrait;
import com.selima.fbi.webserver.PagePart;
import java.awt.Component;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class AbstractMessageBrowserContent<MessageType extends IMailMessage>
extends AbstractClientContent {
    PropertyChangeListener propertyChangeForwarder;
    BrowserTabComponent tabComponent;
    BrowserTabbedPane tabbedPane;
    OuterTabbedPane outerPane;
    MessageType message;
    int pagesPerTab = 10;

    protected AbstractMessageBrowserContent(MailServiceClientContext cctx, MessageType message, String icon, String text) {
        super(cctx, icon, text);
        this.message = message;
        this.addAncestorListener(new Recycler());
    }

    public void removeAllTabs() {
        if (this.outerPane != null) {
            super.remove(this.outerPane);
            this.outerPane = null;
        } else if (this.tabbedPane != null) {
            super.remove(this.tabbedPane);
            this.tabbedPane = null;
        } else if (this.tabComponent != null) {
            super.remove(this.tabComponent);
            this.tabComponent = null;
        }
    }

    void higlight(String text, PagePart pagePart) {
        if (this.outerPane != null) {
            this.outerPane.highlight(text, pagePart);
        } else if (this.tabbedPane != null) {
            this.tabbedPane.highlight(text, pagePart);
        } else if (this.tabComponent != null) {
            this.tabComponent.highlight(text);
        }
    }

    void recycle() {
        if (this.outerPane != null) {
            this.outerPane.recycle();
        } else if (this.tabbedPane != null) {
            this.tabbedPane.recycle();
        } else if (this.tabComponent != null) {
            this.tabComponent.releaseMessageBrowser();
        }
    }

    PagePart getSelectedTab() {
        if (this.outerPane != null) {
            BrowserTabComponent selectedTab = this.outerPane.getSelectedTab();
            return selectedTab == null ? null : selectedTab.pagePart;
        }
        if (this.tabbedPane != null) {
            BrowserTabComponent selectedTab = this.tabbedPane.getSelectedComponent();
            return selectedTab.pagePart;
        }
        if (this.tabComponent != null) {
            return this.tabComponent.pagePart;
        }
        return null;
    }

    PagePart getCurrentPage() {
        return this.getSelectedTab();
    }

    void setSelectedTab(PagePart pagePart) {
        if (this.outerPane != null) {
            this.outerPane.setSelectedTab(pagePart);
        } else if (this.tabbedPane != null) {
            this.tabbedPane.setSelectedTab(pagePart);
        }
    }

    URL getCurrentURL() {
        if (this.outerPane != null) {
            return this.outerPane.getCurrentURL();
        }
        if (this.tabbedPane != null) {
            return this.tabbedPane.getCurrentURL();
        }
        if (this.tabComponent != null) {
            return this.tabComponent.getCurrentURL();
        }
        return null;
    }

    PrintingDetails getPrintingDetails() {
        PrintingDetails result = null;
        if (this.outerPane != null) {
            result = this.outerPane.getPrintingDetails();
        } else if (this.tabbedPane != null) {
            result = this.tabbedPane.getPrintingDetails();
        } else if (this.tabComponent != null) {
            result = this.tabComponent.getPrintingDetails();
        }
        if (result == null) {
            result = new SinglePagePortrait();
        }
        return result;
    }

    boolean hasManyParts() {
        return this.outerPane != null || this.tabbedPane != null;
    }

    public boolean isBackEnabled() {
        if (this.outerPane != null) {
            return this.outerPane.isBackEnabled();
        }
        if (this.tabbedPane != null) {
            return this.tabbedPane.isBackEnabled();
        }
        if (this.tabComponent != null) {
            return this.tabComponent.isBackEnabled();
        }
        return false;
    }

    public void navigateBack() {
        if (this.outerPane != null) {
            this.outerPane.navigateBack();
        } else if (this.tabbedPane != null) {
            this.tabbedPane.navigateBack();
        } else if (this.tabComponent != null) {
            this.tabComponent.navigateBack();
        } else {
            throw new IllegalStateException();
        }
    }

    public boolean isFieldResetable() {
        if (this.outerPane != null) {
            return this.outerPane.isFieldResetable();
        }
        if (this.tabbedPane != null) {
            return this.tabbedPane.isFieldResetable();
        }
        if (this.tabComponent != null) {
            return this.tabComponent.isFieldResetable();
        }
        return false;
    }

    public void resetFieldToPayroll() {
        if (this.outerPane != null) {
            this.outerPane.resetFieldToPayroll();
        } else if (this.tabbedPane != null) {
            this.tabbedPane.resetFieldToPayroll();
        } else if (this.tabComponent != null) {
            this.tabComponent.resetFieldToPayroll();
        } else {
            throw new IllegalStateException();
        }
    }

    public boolean isPageResetable() {
        if (this.outerPane != null) {
            return this.outerPane.isPageResetable();
        }
        if (this.tabbedPane != null) {
            return this.tabbedPane.isPageResetable();
        }
        if (this.tabComponent != null) {
            return this.tabComponent.isPageResetable();
        }
        return false;
    }

    public void resetPageToPayroll() {
        if (this.outerPane != null) {
            this.outerPane.resetPageToPayroll();
        } else if (this.tabbedPane != null) {
            this.tabbedPane.resetPageToPayroll();
        } else if (this.tabComponent != null) {
            this.tabComponent.resetPageToPayroll();
        } else {
            throw new IllegalStateException();
        }
    }

    void addTab(PagePart pagePart) {
        if (this.outerPane != null) {
            this.outerPane.addTab(pagePart);
        } else if (this.tabbedPane != null) {
            if (this.tabbedPane.isFull()) {
                this.outerPane = new OuterTabbedPane(this.createMessageBrowserContext(), this.tabbedPane);
                this.tabbedPane.removePropertyChangeListener("backEnabled", this.propertyChangeForwarder);
                this.tabbedPane.removePropertyChangeListener("fieldResetable", this.propertyChangeForwarder);
                this.tabbedPane.removePropertyChangeListener("pageResetable", this.propertyChangeForwarder);
                this.tabbedPane.removePropertyChangeListener("currentPage", this.propertyChangeForwarder);
                this.remove(this.tabbedPane);
                this.tabbedPane = null;
                this.outerPane.addPropertyChangeListener("backEnabled", this.propertyChangeForwarder);
                this.outerPane.addPropertyChangeListener("fieldResetable", this.propertyChangeForwarder);
                this.outerPane.addPropertyChangeListener("pageResetable", this.propertyChangeForwarder);
                this.outerPane.addPropertyChangeListener("currentPage", this.propertyChangeForwarder);
                this.outerPane.addTab(pagePart);
                this.add((Component)this.outerPane, "Center");
            } else {
                this.tabbedPane.addTab(pagePart);
            }
        } else if (this.tabComponent != null) {
            this.tabbedPane = new BrowserTabbedPane(this.createMessageBrowserContext());
            this.tabbedPane.addTab(this.tabComponent);
            this.tabbedPane.addTab(pagePart);
            this.add((Component)this.tabbedPane, "Center");
            this.tabComponent.removePropertyChangeListener("backEnabled", this.propertyChangeForwarder);
            this.tabComponent.removePropertyChangeListener("fieldResetable", this.propertyChangeForwarder);
            this.tabComponent.removePropertyChangeListener("pageResetable", this.propertyChangeForwarder);
            this.tabbedPane.addPropertyChangeListener("backEnabled", this.propertyChangeForwarder);
            this.tabbedPane.addPropertyChangeListener("fieldResetable", this.propertyChangeForwarder);
            this.tabbedPane.addPropertyChangeListener("pageResetable", this.propertyChangeForwarder);
            this.tabbedPane.addPropertyChangeListener("currentPage", this.propertyChangeForwarder);
            this.tabComponent = null;
        } else {
            this.tabComponent = new BrowserTabComponent(this.createMessageBrowserContext(), pagePart);
            this.add((Component)this.tabComponent, "Center");
            this.propertyChangeForwarder = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractMessageBrowserContent.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            };
            this.tabComponent.addPropertyChangeListener("backEnabled", this.propertyChangeForwarder);
            this.tabComponent.addPropertyChangeListener("fieldResetable", this.propertyChangeForwarder);
            this.tabComponent.addPropertyChangeListener("pageResetable", this.propertyChangeForwarder);
        }
    }

    public void setPagesPerTab(int pagesPerTab) {
        this.pagesPerTab = pagesPerTab;
    }

    private DefaultMessageBrowserContext createMessageBrowserContext() {
        return new DefaultMessageBrowserContext(this.getClientContext(), this, (IMailMessage)this.message, this.getToolBar().getActions(), this.pagesPerTab, this.getHtmlPadding());
    }

    protected Insets getHtmlPadding() {
        return new Insets(0, 0, 0, 0);
    }

    class Recycler
    implements AncestorListener {
        Recycler() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            AbstractMessageBrowserContent.this.recycle();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

