/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.credits.library;

import com.selima.fbi.ui.content.credits.library.LibraryInfo;
import com.selima.fbi.ui.content.credits.library.LibraryResourceResolver;
import com.selima.framework.util.Util;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.TreeMap;

public class LibraryInfos {
    private LibraryInfo[] libraryInfos;

    public LibraryInfos() {
        this(null);
    }

    public LibraryInfos(LibraryInfo[] libraryInfos) {
        this.setLibraryInfos(libraryInfos);
    }

    public LibraryInfo[] getLibraryInfos() {
        return this.libraryInfos;
    }

    public void setLibraryInfos(LibraryInfo[] libraryInfos) {
        if (libraryInfos == null) {
            libraryInfos = new LibraryInfo[]{};
        }
        this.libraryInfos = libraryInfos;
    }

    public static final LibraryInfos create(LibraryResourceResolver resolver) throws IOException {
        InputStream librariesDescriptionStream = resolver.getLibrariesDescription();
        if (librariesDescriptionStream == null) {
            return new LibraryInfos();
        }
        Properties libraryInfoProperties = new Properties();
        libraryInfoProperties.load(librariesDescriptionStream);
        TreeMap<String, LibraryInfo> libraryInfosMap = new TreeMap<String, LibraryInfo>();
        for (Object keyObject : libraryInfoProperties.keySet()) {
            try {
                String key = (String)keyObject;
                String value = (String)libraryInfoProperties.get(key);
                int lastDot = key.lastIndexOf(46);
                String libFileName = key.substring(0, lastDot);
                String suffix = key.substring(lastDot + 1);
                LibraryInfo info = (LibraryInfo)libraryInfosMap.get(libFileName);
                if (info == null) {
                    info = new LibraryInfo();
                    info.setFileName(libFileName);
                    libraryInfosMap.put(libFileName, info);
                }
                if ("name".equals(suffix)) {
                    info.setName(value);
                }
                if ("description".equals(suffix)) {
                    info.setDescription(value);
                }
                if (!"homepage".equals(suffix)) continue;
                info.setHomepage(value);
            }
            catch (Throwable e) {
                LogAPI.logWarning((Throwable)e);
            }
        }
        for (LibraryInfo info : libraryInfosMap.values()) {
            try {
                InputStream licenceStream;
                if (Util.isEmpty((Object)info.getName())) {
                    info.setName(info.getFileName());
                }
                if (Util.isEmpty((Object)info.getDescription())) {
                    info.setDescription(info.getName());
                }
                if ((licenceStream = resolver.getLicence(info.getFileName())) == null) continue;
                String licence = new String(Util.read((InputStream)licenceStream));
                info.setLicence(licence);
            }
            catch (Throwable e) {
                LogAPI.logWarning((Throwable)e);
            }
        }
        return new LibraryInfos(libraryInfosMap.values().toArray(new LibraryInfo[0]));
    }
}

