/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.credits.library;

import com.selima.fbi.ui.content.credits.library.DefaultLibraryResourceResolver;
import com.selima.fbi.ui.content.credits.library.LibraryResourceResolver;
import com.selima.framework.util.Util;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class CheckLibraryInfosTask
extends Task {
    private File libDir;
    private String[] develOnlyLibs;
    private String develOnlyLibsFilesetId;
    private LibraryResourceResolver resourceResolver = new DefaultLibraryResourceResolver();

    public File getLibDir() throws BuildException {
        if (Util.isEmpty((Object)this.libDir)) {
            throw new BuildException("missing libDir");
        }
        if (!this.libDir.exists() || !this.libDir.isDirectory()) {
            throw new BuildException("libDir should be an existing directory. Supplied value: " + this.libDir);
        }
        return this.libDir;
    }

    public void setLibDir(File libDir) {
        this.libDir = libDir;
    }

    public String[] getDevelOnlyLibs() throws BuildException {
        if (this.develOnlyLibs == null && this.develOnlyLibsFilesetId == null) {
            throw new BuildException("missing develOnlyLibs or develOnlyLibsFilesetId");
        }
        if (this.develOnlyLibs != null) {
            return this.develOnlyLibs;
        }
        ArrayList<String> develOnlyLibsList = new ArrayList<String>();
        ResourceCollection rc = (ResourceCollection)this.getProject().getReference(this.develOnlyLibsFilesetId);
        for (Object o : rc) {
            if (!(o instanceof FileResource)) continue;
            File file = ((FileResource)o).getFile();
            develOnlyLibsList.add(file.getName());
        }
        return develOnlyLibsList.toArray(new String[0]);
    }

    public void setDevelOnlyLibs(String[] develOnlyLibs) {
        this.develOnlyLibs = develOnlyLibs;
    }

    public void setDevelOnlyLibsFilesetId(String develOnlyLibsFilesetId) {
        this.develOnlyLibsFilesetId = develOnlyLibsFilesetId;
    }

    public void setResourceResolver(LibraryResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public void execute() throws BuildException {
        try {
            final HashSet<String> ignoredFiles = new HashSet<String>();
            ignoredFiles.addAll(Arrays.asList(this.getDevelOnlyLibs()));
            File[] prodLibs = this.getLibDir().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String fileName = file.getName();
                    String fileNameLC = fileName.toLowerCase();
                    return file.isFile() && (fileNameLC.endsWith(".jar") || fileNameLC.endsWith(".zip")) && !ignoredFiles.contains(fileName);
                }
            });
            Properties libraryInfoProperties = new Properties();
            InputStream librariesInfo = this.resourceResolver.getLibrariesDescription();
            if (librariesInfo == null) {
                throw new BuildException("The file lib/libraries.description.txt not found");
            }
            libraryInfoProperties.load(librariesInfo);
            for (File prodLib : prodLibs) {
                String libFileName = prodLib.getName();
                InputStream licence = this.resourceResolver.getLicence(libFileName);
                if (licence == null) {
                    throw new BuildException("Licence file for " + libFileName + " not found");
                }
                if (libraryInfoProperties.containsKey(libFileName + ".name") || libraryInfoProperties.containsKey(libFileName + ".description") || libraryInfoProperties.containsKey(libFileName + ".homepage")) continue;
                throw new BuildException("Missing library information in lib/libraries.description.txt for " + libFileName);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

