/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content.credits;

import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.ResourceDrivenLayout;
import com.selima.fbi.ui.common.TitledPanel;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.content.AbstractClientContent;
import com.selima.fbi.ui.content.credits.library.DefaultLibraryResourceResolver;
import com.selima.fbi.ui.content.credits.library.LibraryInfo;
import com.selima.fbi.ui.content.credits.library.LibraryInfos;
import com.selima.framework.exception.BackendException;
import com.selima.framework.exception.ErrorItem;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class LibrariesContent
extends AbstractClientContent {
    private JTabbedPane licencePane;
    private boolean opened;

    public LibrariesContent(MailServiceClientContext context) {
        super(context, "/img/32x32/actions/libraries.png", "Opening Product Information");
        this.initComponents();
    }

    @Override
    public String getContentName() {
        return "Credits";
    }

    @Override
    public String getDescription() {
        return "Product Information";
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    @Override
    public ToolBar getToolBar() {
        return null;
    }

    @Override
    public BackendWork getOpeningWork() {
        if (this.opened) {
            return super.getOpeningWork();
        }
        this.opened = true;
        return new LoadLibrariesWork();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JScrollPane(new JPanel(){
            {
                this.setLayout(new BoxLayout(this, 1));
                this.add(LibrariesContent.this.createLibrariesPanel());
            }
        }, 20, 31));
    }

    private JPanel createLibrariesPanel() {
        TitledPanel panel = new TitledPanel("Third Party Libraries");
        panel.setLayout(new BoxLayout(panel, 1));
        Object oldInsets = UIManager.get("TabbedPane.contentBorderInsets");
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(0, 1, 0, 0));
        this.licencePane = new JTabbedPane(2, 1);
        UIManager.put("TabbedPane.contentBorderInsets", oldInsets);
        this.licencePane.setName("LibrariesInfoTabbedPane");
        panel.add(this.licencePane);
        return panel;
    }

    private JPanel createLibraryInfoPanel(LibraryInfo info) {
        String layout = "+-------------------------------------------+--------------------------------------+\n| NameLabel NONE WEST 5  5 5 5              | NameValue NONE WEST  5 5 5 5         |\n+-------------------------------------------+--------------------------------------+\n| FileLabel NONE WEST 0 5 5 5               | FileValue NONE WEST  0 5 5 5         |\n+-------------------------------------------+--------------------------------------+\n| HomepageLabel NONE WEST 0 5 5 5           | HomepageValue NONE WEST  0 5 5 5     |\n+-------------------------------------------+--------------------------------------+\n| DescriptionLabel NONE WEST 0 5 5 5        | DescriptionValue NONE WEST  0 5 5 5  |\n+-------------------------------------------+--------------------------------------+\n| LicenceLabel NONE WEST 0 5 5 5                                                   |\n+----------------------------------------------------------------------------------+\n| LicenceValue BOTH WEST 0 5 5 5 80% 80%                                           |\n+----------------------------------------------------------------------------------+\n";
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new ResourceDrivenLayout(layout));
        infoPanel.add((Component)new JLabel("Library Name:"), "NameLabel");
        infoPanel.add((Component)new JLabel("<html><b>" + info.getName() + "</b><htm>"), "NameValue");
        infoPanel.add((Component)new JLabel("Library File:"), "FileLabel");
        infoPanel.add((Component)new JLabel(info.getFileName()), "FileValue");
        infoPanel.add((Component)new JLabel("Web Page:"), "HomepageLabel");
        final String homepage = info.getHomepage();
        JLabel homePageLabel = new JLabel("<html><a href='" + homepage + "'>" + homepage + "</a></html>");
        homePageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1));
        homePageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JLabel label = (JLabel)evt.getComponent();
                label.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    Desktop.getDesktop().browse(new URI(homepage));
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                }
                catch (URISyntaxException e) {
                    LogAPI.logSevere((Throwable)e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JLabel label = (JLabel)evt.getComponent();
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1));
            }
        });
        homePageLabel.setCursor(Cursor.getPredefinedCursor(12));
        infoPanel.add((Component)homePageLabel, "HomepageValue");
        infoPanel.add((Component)new JLabel("Description:"), "DescriptionLabel");
        infoPanel.add((Component)new JLabel(info.getDescription()), "DescriptionValue");
        infoPanel.add((Component)new JLabel("Licence:"), "LicenceLabel");
        JTextArea textArea = new JTextArea(25, 50);
        textArea.setName("LicenceTextArea");
        textArea.setEditable(false);
        textArea.setText(info.getLicence());
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 30);
        infoPanel.add((Component)scrollPane, "LicenceValue");
        return infoPanel;
    }

    private final class LoadLibrariesWork
    implements BackendWork {
        private LoadLibrariesWork() {
        }

        public String getName() {
            return "Loading libraries information";
        }

        public void invokeBackend(BackendOperationHandle handle) throws BackendException {
            try {
                LibraryInfos infos = LibraryInfos.create(new DefaultLibraryResourceResolver());
                handle.setResult((Object)infos);
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e, new ErrorItem[0]);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() != null) {
                return;
            }
            LibraryInfos infos = (LibraryInfos)handle.getResult();
            Dimension tabHeaderSize = new JLabel("Commons Collections ").getPreferredSize();
            for (LibraryInfo info : infos.getLibraryInfos()) {
                JPanel infoPanel = LibrariesContent.this.createLibraryInfoPanel(info);
                LibrariesContent.this.licencePane.add(info.getName(), infoPanel);
                JLabel label = new JLabel(info.getName());
                label.setMinimumSize(tabHeaderSize);
                label.setMaximumSize(tabHeaderSize);
                label.setPreferredSize(tabHeaderSize);
                label.setFocusable(false);
                LibrariesContent.this.licencePane.setTabComponentAt(LibrariesContent.this.licencePane.getTabCount() - 1, label);
            }
        }
    }
}

