/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.swing.PrintingStatus;

public abstract class PrintAction
extends AbstractAction
implements BackendWork {
    private ClientContext clientContext;
    private PrinterJob printerJob;
    private Component anchorComponent;
    private PrintingStatus printingStatus;
    private PrintRequestAttributeSet printerAttributes;

    public PrintAction(ClientContext clientContext) {
        super("Print", SwingHelper.imageIcon("/img/16x16/actions/fileprint.png"));
        UIManager.put("PrintingDialog.titleProgressText", clientContext.getTitle());
        this.clientContext = clientContext;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.anchorComponent = (Component)evt.getSource();
        this.printerJob = PrinterJob.getPrinterJob();
        if (this.printerAttributes == null) {
            this.printerAttributes = this.initPrinterAttributes();
        }
        this.configurePrinterAttributes(this.printerAttributes);
        if (this.printerJob.printDialog(this.printerAttributes)) {
            this.setEnabled(false);
            this.printingStatus = PrintingStatus.createPrintingStatus(SwingUtilities.getWindowAncestor(this.anchorComponent), this.printerJob);
            this.clientContext.getSubmitter().submitWork((BackendWork)this);
            this.clientContext.getStatusBar().displayMessage(this.getName());
            this.printingStatus.showModal(true);
        }
    }

    public String getName() {
        return "Printing '" + this.getPrintName() + "'";
    }

    public void invokeBackend(BackendOperationHandle handle) {
        try {
            Printable printable = this.createPrintable(this.printingStatus, handle);
            if (printable != null) {
                this.printerJob.setPrintable(printable);
                this.printerJob.print(this.printerAttributes);
            }
        }
        catch (PrinterAbortException printable) {
        }
        catch (PrinterException e) {
            handle.setFailure((Throwable)e);
        }
    }

    public void invokeSwing(SwingOperationHandle handle) {
        try {
            if (this.printingStatus != null) {
                this.printingStatus.dispose();
            }
            this.setEnabled(true);
            if (handle.getFailure() != null) {
                FailureDialog.show(this.clientContext.getTitle(), "<html>Failed to print <br><b>" + this.getPrintName() + "</b></html>", handle.getFailure());
                LogAPI.logSevere((Throwable)handle.getFailure());
            }
            this.clientContext.getStatusBar().displayMessage("Printing finished");
        }
        finally {
            this.printerJob = null;
            this.printingStatus = null;
            this.anchorComponent = null;
        }
    }

    protected abstract String getPrintName();

    protected abstract Printable createPrintable(PrintingStatus var1, BackendOperationHandle var2);

    protected PrintRequestAttributeSet initPrinterAttributes() {
        HashPrintRequestAttributeSet printerAttributes = new HashPrintRequestAttributeSet();
        printerAttributes.add(MediaSizeName.ISO_A4);
        return printerAttributes;
    }

    protected void configurePrinterAttributes(PrintRequestAttributeSet printerAttributes) {
        printerAttributes.add(new JobName(this.getPrintName(), null));
        printerAttributes.add(OrientationRequested.PORTRAIT);
    }

    protected void setMaxAvailableSpace(PrintRequestAttributeSet printerAttributes) {
        MediaPrintableArea[] maxArea = (MediaPrintableArea[])this.printerJob.getPrintService().getSupportedAttributeValues(MediaPrintableArea.class, DocFlavor.SERVICE_FORMATTED.PAGEABLE, printerAttributes);
        if (maxArea.length > 0) {
            printerAttributes.add(maxArea[0]);
        }
    }
}

