/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.core.body.IStatusRecord;
import com.selima.fbi.submission.core.body.IStatusReport;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.AbstractBackendAction;
import com.selima.fbi.ui.common.DatePopupDialog;
import com.selima.fbi.ui.common.SelectionAction;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.common.table.Column;
import com.selima.fbi.ui.common.table.ContentTable;
import com.selima.fbi.ui.common.table.RowTableModel;
import com.selima.fbi.ui.common.table.RowTableModelColumn;
import com.selima.fbi.ui.common.table.RowTableModelGetter;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.common.waitdlg.StatusReportModel;
import com.selima.fbi.ui.content.AbstractTableContent;
import com.selima.fbi.ui.content.MultiSaveAction;
import com.selima.fbi.ui.content.detail.SentDetailContent;
import com.selima.fbi.ui.content.result.CompletionContent;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class IncompleteContent
extends AbstractTableContent<StatusReportTable> {
    private DateBaseEditor fromDateField;
    private DateBaseEditor toDateField;
    ToolBar toolBar;

    public IncompleteContent(MailServiceClientContext cctx) {
        super(cctx, "/img/32x32/apps/mail_incomplete.png", null, new StatusReportTable(cctx));
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        this.fromDateField = new DateBaseEditor("Enter Starting Date");
        this.fromDateField.setEditorValue(cal.getTime());
        this.toDateField = new DateBaseEditor("Enter Ending Date");
        this.toDateField.setEditorValue(new Date());
        this.toolBar = new ToolBar(Box.createHorizontalStrut(10), new JLabel("From"), Box.createHorizontalStrut(5), this.fromDateField, Box.createHorizontalStrut(10), new JLabel("To"), Box.createHorizontalStrut(5), this.toDateField, Box.createHorizontalStrut(10), new StatusReportAction(), new DetailAction(), new SaveAction(), new CompleteAction());
        for (Action action : this.toolBar.getActions()) {
            ((StatusReportTable)this.table).getPopupMenu().add(action);
        }
        ((StatusReportTable)this.table).addMouseListener(new DetailDoubleClicker());
    }

    @Override
    public String getContentName() {
        return "Incomplete";
    }

    @Override
    public String getDescription() {
        return "Troublesome submissions";
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.incomplete";
    }

    public void hideRows(List<IPAYEMessage> messages) {
        ((StatusReportTable)this.table).hideRows(messages);
    }

    private void showDetail(IPAYEMessage message) {
        this.getClientContext().displayContent(new SentDetailContent<IncompleteContent>(this.getClientContext(), this, message));
    }

    public class DateBaseEditor
    extends JPanel {
        protected JButton button;
        protected JFormattedTextField textField;

        public DateBaseEditor(String toolTip) {
            super(new BorderLayout(0, 0));
            this.initComponents(toolTip);
            this.setMaximumSize(this.getPreferredSize());
        }

        protected void initComponents(String toolTip) {
            this.textField = new JFormattedTextField(DateFormat.getDateInstance());
            this.textField.setFocusLostBehavior(1);
            this.textField.setColumns(10);
            this.textField.setToolTipText(toolTip);
            this.add((Component)this.textField, "Center");
            this.button = new JButton(SwingHelper.imageIcon("/img/16x16/calendar.png"));
            Dimension dim = new Dimension(19, 19);
            this.button.setFocusable(false);
            this.button.setMinimumSize(dim);
            this.button.setPreferredSize(dim);
            this.button.setMaximumSize(dim);
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setToolTipText(toolTip);
            this.add((Component)this.button, "East");
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Date returnValue = new DatePopupDialog((JFrame)SwingUtilities.getWindowAncestor(DateBaseEditor.this), IncompleteContent.this.getClientContext().getTitle()).popup(DateBaseEditor.this.getEditorValue());
                    if (returnValue != null) {
                        DateBaseEditor.this.setEditorValue(returnValue);
                    }
                }
            });
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.button.setEnabled(enabled);
            this.textField.setEnabled(enabled);
        }

        public Date getEditorValue() {
            Date date = (Date)this.textField.getValue();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }

        public void setEditorValue(Date value) {
            this.textField.setValue(value);
        }
    }

    class CompleteAction
    extends SelectionAction
    implements ListSelectionListener {
        CompleteAction() {
            super("Complete", "/img/16x16/actions/redo.png", IncompleteContent.this.table);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IncompleteContent.this.getClientContext().displayContent(new CompletionContent(IncompleteContent.this.getClientContext(), IncompleteContent.this, ((StatusReportTable)IncompleteContent.this.table).getSelectedMessages()));
        }
    }

    class SaveAction
    extends MultiSaveAction {
        SaveAction() {
            super(IncompleteContent.this.getClientContext(), IncompleteContent.this.table);
        }

        @Override
        protected IMailMessage getMessage(int index) {
            return ((StatusReportTable)IncompleteContent.this.table).getModel().getMessage(index);
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            super.valueChanged(evt);
            ListSelectionModel selectionModel = (ListSelectionModel)evt.getSource();
            if (!selectionModel.isSelectionEmpty()) {
                for (int i = selectionModel.getMinSelectionIndex(); i <= selectionModel.getMaxSelectionIndex(); ++i) {
                    if (((StatusReportTable)IncompleteContent.this.table).getModel().getMessage(i).getFormType() != FormType.UKNOWN) continue;
                    this.setEnabled(false);
                }
            }
        }
    }

    class DetailAction
    extends SelectionAction
    implements ListSelectionListener {
        DetailAction() {
            super("Open", "/img/16x16/mimetypes/dvi.png", IncompleteContent.this.table);
            this.setEnabled(false);
        }

        @Override
        public boolean isEnabled() {
            if (IncompleteContent.this.table != null) {
                Point popupPoint = ((StatusReportTable)IncompleteContent.this.table).getPopupPoint();
                if (popupPoint != null) {
                    IPAYEMessage message = ((StatusReportTable)IncompleteContent.this.table).getMessageAt(popupPoint);
                    return message != null && message.getFormType() != FormType.UKNOWN;
                }
                return ((StatusReportTable)IncompleteContent.this.table).getLeadMessage() != null && ((StatusReportTable)IncompleteContent.this.table).getLeadMessage().getFormType() != FormType.UKNOWN;
            }
            return false;
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            this.setEnabled(((StatusReportTable)IncompleteContent.this.table).getLeadMessage() != null && ((StatusReportTable)IncompleteContent.this.table).getLeadMessage().getFormType() != FormType.UKNOWN);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point popupPoint = ((StatusReportTable)IncompleteContent.this.table).getPopupPoint();
            IPAYEMessage message = popupPoint != null ? ((StatusReportTable)IncompleteContent.this.table).getMessageAt(popupPoint) : ((StatusReportTable)IncompleteContent.this.table).getLeadMessage();
            if (message != null) {
                IncompleteContent.this.showDetail(message);
            }
        }
    }

    class DetailDoubleClicker
    extends MouseAdapter {
        DetailDoubleClicker() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            IPAYEMessage message;
            if (evt.getClickCount() == 2 && (message = ((StatusReportTable)IncompleteContent.this.table).getMessageAt(evt.getPoint())) != null && message.getFormType() != FormType.UKNOWN) {
                IncompleteContent.this.showDetail(message);
            }
        }
    }

    class StatusReportAction
    extends AbstractBackendAction {
        StatusReportAction() {
            super("Refresh", SwingHelper.imageIcon("/img/16x16/actions/reload.png"));
        }

        public String getName() {
            return "Downloading Status Report";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            try {
                IdentityHashMap<IStatusRecord, IPAYEMessage> results = new IdentityHashMap<IStatusRecord, IPAYEMessage>();
                for (SubmitClass submitClass : Arrays.asList(SubmitClass.HMRC_PAYE_RTI_FPS, SubmitClass.HMRC_PAYE_RTI_FPS_TIL, SubmitClass.HMRC_PAYE_RTI_EPS, SubmitClass.HMRC_PAYE_RTI_EPS_TIL, SubmitClass.HMRC_PAYE_RTI_EYU, SubmitClass.HMRC_PAYE_RTI_EYU_TIL, SubmitClass.HMRC_PAYE_RTI_NVR, SubmitClass.HMRC_PAYE_RTI_NVR_TIL)) {
                    handle.checkCancelRequest();
                    Date fromDate = IncompleteContent.this.fromDateField.getEditorValue();
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(IncompleteContent.this.toDateField.getEditorValue());
                    calendar.add(5, 1);
                    Date toDate = calendar.getTime();
                    IStatusReport result = IncompleteContent.this.getClientContext().getMailService().getPAYEStatusReport(submitClass, fromDate, toDate);
                    if (result.getStatusRecords() == null) continue;
                    for (IStatusRecord record : result.getStatusRecords()) {
                        handle.checkCancelRequest();
                        IPAYEMessage message = IncompleteContent.this.getClientContext().getMailService().getPAYEMessage(submitClass, record.getCorrelationID());
                        if (message != null) {
                            results.put(record, message);
                            continue;
                        }
                        LogAPI.logWarning((String)("Unable to complete message:" + record.getCorrelationID()));
                    }
                }
                handle.setResult(results);
            }
            catch (CancelException e) {
                throw new CanceledException((Exception)e);
            }
            catch (SubmitException e) {
                handle.setFailure((Throwable)e);
            }
            catch (IOException e) {
                handle.setFailure((Throwable)e);
            }
            finally {
                SingletonWaitingDialog.hideDialog();
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getResult() != null) {
                ((StatusReportTable)IncompleteContent.this.table).setReport((Map)handle.getResult());
            } else if (!(handle.getFailure() instanceof CanceledException)) {
                FailureDialog.show(IncompleteContent.this.getClientContext().getTitle(), "<b>Failed to retrieve Status Report</b>", handle.getFailure());
                LogAPI.logSevere((Throwable)handle.getFailure());
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SingletonWaitingDialog.showDialog(IncompleteContent.this.getClientContext(), new StatusReportModel(), this);
            SwingOperationHandle handle = IncompleteContent.this.getClientContext().getSubmitter().submitWork((BackendWork)this);
            super.setTaskHandle(handle);
        }
    }

    static class StatusReportTableModel
    extends RowTableModel<StatusData> {
        private static CorrelationIDGetter correlationIDGetter = new CorrelationIDGetter();
        private static StatusGetter statusGetter = new StatusGetter();
        private static SubjectGetter subjectGetter = new SubjectGetter();
        static RowTableModelColumn<StatusData> SUBJECT_COLUMN = new RowTableModelColumn<StatusData>("Subject", 270, 2, subjectGetter);
        static RowTableModelColumn<StatusData> CORRELATION_ID_COLUMN = new RowTableModelColumn<StatusData>("Correlation ID", 220, 2, correlationIDGetter);
        static RowTableModelColumn<StatusData> TIME_COLUMN = new RowTableModelColumn<StatusData>("Time", 120, 0, new TimeStampGetter());
        static RowTableModelColumn<StatusData> STATUS_COLUMN = new RowTableModelColumn<StatusData>("Status", 200, 2, statusGetter);
        static Map<String, RowTableModelColumn<?>> MAP_OF_COLUMNS = new HashMap();

        StatusReportTableModel() {
            super(SUBJECT_COLUMN, CORRELATION_ID_COLUMN, TIME_COLUMN, STATUS_COLUMN);
        }

        @Override
        public Map<String, RowTableModelColumn<?>> getMapOfColumns() {
            return MAP_OF_COLUMNS;
        }

        public void hideRowsForMessages(List<IPAYEMessage> messages) {
            ArrayList<StatusData> hiddenRows = new ArrayList<StatusData>(messages.size());
            for (int i = 0; i < this.getRowCount(); ++i) {
                StatusData statusData = (StatusData)this.getRowValue(i);
                if (!messages.contains(statusData.message)) continue;
                hiddenRows.add(statusData);
            }
            this.hideRows(hiddenRows);
        }

        void setReport(Map<IStatusRecord, IPAYEMessage> dataMap) {
            StatusRow[] rows = new StatusRow[dataMap.size()];
            int i = 0;
            for (Map.Entry<IStatusRecord, IPAYEMessage> entry : dataMap.entrySet()) {
                rows[i] = new StatusRow(i, entry.getKey(), entry.getValue());
                ++i;
            }
            super.setRows(rows);
            this.fireTableDataChanged();
        }

        IPAYEMessage getMessage(int index) {
            return ((StatusData)this.getRowValue((int)index)).message;
        }

        String getTitle(int index) {
            return subjectGetter.getValue((StatusData)this.getRowValue(index));
        }

        String getStatus(int index) {
            return statusGetter.getValue((StatusData)this.getRowValue(index));
        }

        static {
            for (RowTableModelColumn column : Arrays.asList(SUBJECT_COLUMN, CORRELATION_ID_COLUMN, TIME_COLUMN, STATUS_COLUMN)) {
                MAP_OF_COLUMNS.put(column.getTitle(), column);
            }
        }

        static class SubjectGetter
        implements RowTableModelGetter<StatusData> {
            SubjectGetter() {
            }

            public String getValue(StatusData row) {
                return row.message.getSubject();
            }
        }

        static class StatusGetter
        implements RowTableModelGetter<StatusData> {
            StatusGetter() {
            }

            public String getValue(StatusData row) {
                return row.status.getStatus();
            }
        }

        static class TimeStampGetter
        implements RowTableModelGetter<StatusData> {
            TimeStampGetter() {
            }

            public String getValue(StatusData row) {
                return row.status.getTimeStamp();
            }
        }

        static class CorrelationIDGetter
        implements RowTableModelGetter<StatusData> {
            CorrelationIDGetter() {
            }

            public String getValue(StatusData row) {
                return row.status.getCorrelationID();
            }
        }

        class StatusRow
        extends RowTableModel.TableRow<StatusData> {
            StatusData data;

            public StatusRow(int rowIndex, IStatusRecord status, IPAYEMessage message) {
                super(rowIndex);
                this.data = new StatusData(status, message);
            }

            @Override
            public StatusData getRowData() {
                return this.data;
            }
        }
    }

    static class StatusData {
        IStatusRecord status;
        IPAYEMessage message;

        StatusData(IStatusRecord status, IPAYEMessage message) {
            this.status = status;
            this.message = message;
        }
    }

    public static class StatusReportTable
    extends ContentTable {
        StatusReportTable(ClientContext context) {
            super(context, new StatusReportTableModel());
            this.setDefaultRenderer(Object.class, new CellRenderer(this.getDefaultRenderer(Object.class)));
        }

        @Override
        public StatusReportTableModel getModel() {
            return (StatusReportTableModel)super.getModel();
        }

        void setReport(Map<IStatusRecord, IPAYEMessage> dataMap) {
            this.getModel().setReport(dataMap);
        }

        void hideRows(List<IPAYEMessage> messages) {
            this.getModel().hideRowsForMessages(messages);
        }

        List<IPAYEMessage> getSelectedMessages() {
            int[] rows = this.getSelectedRows();
            ArrayList<IPAYEMessage> result = new ArrayList<IPAYEMessage>(rows.length);
            for (int i = 0; i < rows.length; ++i) {
                result.add(this.getModel().getMessage(rows[i]));
            }
            return result;
        }

        IPAYEMessage getLeadMessage() {
            int leadIndex = this.getSelectionModel().getLeadSelectionIndex();
            if (leadIndex >= 0 && leadIndex < this.getRowCount()) {
                return this.getModel().getMessage(leadIndex);
            }
            return null;
        }

        IPAYEMessage getMessageAt(Point p) {
            int row = this.rowAtPoint(p);
            if (row >= 0 && row < this.getRowCount()) {
                return this.getModel().getMessage(row);
            }
            return null;
        }

        public String getSelectionDescription(int index) {
            return this.getModel().getTitle(index);
        }

        private class CellRenderer
        implements TableCellRenderer {
            private final Icon MAIL_ICON;
            private TableCellRenderer wrapped;

            private CellRenderer(TableCellRenderer renderer) {
                this.wrapped = renderer;
                this.MAIL_ICON = SwingHelper.imageIcon("/img/16x16/apps/mail_incomplete.png");
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp = this.wrapped.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    int alignment = ((Column)table.getColumnModel().getColumn(column).getIdentifier()).getAlign();
                    label.setHorizontalAlignment(alignment);
                    label.setBorder(BorderFactory.createCompoundBorder(label.getBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
                    if (column == 0) {
                        label.setIcon(this.MAIL_ICON);
                    } else {
                        label.setIcon(null);
                    }
                    if ("SUBMISSION_ERROR".equals(StatusReportTable.this.getModel().getStatus(row))) {
                        comp.setForeground(Color.RED);
                    } else {
                        comp.setForeground(Color.BLACK);
                    }
                }
                return comp;
            }
        }
    }
}

