/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.waitdlg;

import com.selima.fbi.DPSServiceListener;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.NetworkListener;
import com.selima.fbi.PAYEServiceListener;
import com.selima.fbi.plugin.IPayrollPluginListener;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.waitdlg.IProgressModel;
import com.selima.fbi.ui.common.waitdlg.IWaitingInterrupter;
import com.selima.fbi.ui.common.waitdlg.MailServiceInterrupter;
import com.selima.fbi.ui.common.waitdlg.MailServiceWaiting;
import com.selima.fbi.ui.common.waitdlg.SafetyMailServiceInterrupter;
import com.selima.fbi.ui.common.waitdlg.WaitingDialog;

class WaitingSession {
    IProgressModel model;
    IMailServiceFacade facade;
    WaitingDialog waitingDialog;
    IWaitingInterrupter interrupter;
    MailServiceClientContext clientContext;

    public WaitingSession(MailServiceClientContext context, IProgressModel model, IWaitingInterrupter interrupter) {
        this.model = model;
        this.clientContext = context;
        this.interrupter = interrupter;
        this.facade = context.getMailService();
        this.waitingDialog = new WaitingDialog(model);
        if (model instanceof PAYEServiceListener) {
            this.facade.addPAYEServiceListener((PAYEServiceListener)((Object)model));
        }
        if (model instanceof NetworkListener) {
            this.facade.addNetworkListener((NetworkListener)((Object)model));
        }
        if (model instanceof DPSServiceListener) {
            this.facade.addDPSServiceListener((DPSServiceListener)((Object)model));
        }
        if (model instanceof MailServiceWaiting) {
            this.facade = context.getMailService();
            this.interrupter = new SafetyMailServiceInterrupter(this.clientContext, new MailServiceInterrupter(this.interrupter, this.facade), this.waitingDialog);
        }
        if (model instanceof IPayrollPluginListener) {
            this.facade.addPayrollPluginListener((IPayrollPluginListener)((Object)model));
        }
        this.waitingDialog.setInterrupter(this.interrupter);
        this.waitingDialog.pack();
    }

    public IProgressModel getModel() {
        return this.model;
    }

    public WaitingDialog getDialog() {
        return this.waitingDialog;
    }

    public void close() {
        this.waitingDialog.dispose();
        if (this.model instanceof PAYEServiceListener) {
            this.facade.removePAYEServiceListener((PAYEServiceListener)((Object)this.model));
        }
        if (this.model instanceof NetworkListener) {
            this.facade.removeNetworkListener((NetworkListener)((Object)this.model));
        }
        if (this.model instanceof DPSServiceListener) {
            this.facade.removeDPSServiceListener((DPSServiceListener)((Object)this.model));
        }
        if (this.model instanceof IPayrollPluginListener) {
            this.facade.removePayrollPluginListener((IPayrollPluginListener)((Object)this.model));
        }
    }
}

