/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.waitdlg;

import com.selima.fbi.threading.GWImageSupplyFactory;
import com.selima.fbi.threading.WaitingPanel;
import com.selima.fbi.ui.MainFrame;
import com.selima.fbi.ui.common.waitdlg.IProgressModel;
import com.selima.fbi.ui.common.waitdlg.IWaitingInterrupter;
import com.selima.fbi.ui.common.waitdlg.ProgressEvent;
import com.selima.fbi.ui.common.waitdlg.ProgressListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class WaitingDialog
extends JDialog
implements ProgressListener {
    private static final int TIMER_FREQUENCY = 4;
    private long stepStart;
    private WaitingPanel waitingPanel;
    private JPanel cancelPanel;
    private IWaitingInterrupter interrupter;
    private JProgressBar progressBar;
    private JProgressBar timerBar;
    private Timer timer = new Timer(250, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int value = (int)((System.currentTimeMillis() - WaitingDialog.this.stepStart) * 4L / 1000L);
            value = Math.min(value, WaitingDialog.this.timerBar.getMaximum());
            WaitingDialog.this.timerBar.setValue(value);
        }
    });
    private IProgressModel model;
    boolean packing;

    public WaitingDialog(IProgressModel model) {
        this(model, true);
    }

    WaitingDialog(IProgressModel model, boolean pack) {
        super(WaitingDialog.parentFrame(), null, true);
        this.setDefaultCloseOperation(0);
        this.setUndecorated(true);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBackground(SystemColor.control);
        contentPane.setOpaque(true);
        this.waitingPanel = new WaitingPanel(GWImageSupplyFactory.createCompoundImageSupply(GWImageSupplyFactory.createPaintedBackgroundSupply(Color.WHITE, contentPane.getBackground()), GWImageSupplyFactory.createMultiImageSupply(model.getBackgroundImages()), GWImageSupplyFactory.createMovingImageSupply(model.getMovingImage(), model.isLeftToRight() ? 1 : -1, false, false)), 100);
        contentPane.add(this.waitingPanel);
        this.timerBar = new JProgressBar(0, 1);
        this.timerBar.setStringPainted(true);
        this.timerBar.setBackground(Color.WHITE);
        this.timerBar.setBorderPainted(false);
        if (this.timerBar.getUI().getClass() != BasicProgressBarUI.class) {
            this.timerBar.setUI(new BasicProgressBarUI());
        }
        this.timerBar.setString("");
        contentPane.add(this.timerBar);
        contentPane.add(Box.createVerticalStrut(1));
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setStringPainted(true);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setBackground(Color.WHITE);
        this.progressBar.setBorderPainted(false);
        if (this.progressBar.getUI().getClass() != BasicProgressBarUI.class) {
            this.progressBar.setUI(new BasicProgressBarUI());
        }
        contentPane.add(this.progressBar);
        JButton cancelButton = new JButton("Cancel");
        this.cancelPanel = new JPanel(new FlowLayout(1, 0, 10));
        this.cancelPanel.add(cancelButton);
        this.cancelPanel.setVisible(false);
        contentPane.add(this.cancelPanel);
        CancelListener listener = new CancelListener();
        cancelButton.addActionListener(listener);
        this.addWindowListener(listener);
        contentPane.setBorder(BorderFactory.createBevelBorder(0, SystemColor.controlHighlight, SystemColor.controlShadow));
        if (pack) {
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
        this.model = model;
        model.addListener(this);
        this.stepStart = System.currentTimeMillis();
        this.setupTimerBar(model.getStepDuration(), model.getEventDetail());
        this.setupProgressBar(model.getCurrentStep(), model.getNumberOfSteps(), model.getStepMessage());
    }

    @Override
    public void setVisible(boolean state) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WaitingDialog.this.waitingPanel.start();
            }
        });
        super.setVisible(state);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        Dimension size = this.getSize();
        Dimension pref = this.getPreferredSize();
        if (!size.equals(pref)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WaitingDialog.this.pack();
                    WaitingDialog.this.setLocationRelativeTo(WaitingDialog.this.getParent());
                }
            });
        }
    }

    @Override
    public void pack() {
        if (!this.packing) {
            try {
                this.packing = true;
                super.pack();
            }
            finally {
                this.packing = false;
            }
        }
    }

    public void setInterrupter(IWaitingInterrupter interrupter) {
        this.interrupter = interrupter;
        this.cancelPanel.setVisible(interrupter != null);
    }

    public IProgressModel getModel() {
        return this.model;
    }

    @Override
    public void stateChanged(ProgressEvent evt) {
        this.setupTimerBar(evt.stepDuration, evt.eventDetail);
        this.setupProgressBar(evt.currentStep, evt.numberOfSteps, evt.stepMessage);
        if (!evt.instepUpdate) {
            this.stepStart = System.currentTimeMillis();
            this.timerBar.setValue(0);
        }
    }

    void setupTimerBar(int stepDuration, String message) {
        if (stepDuration > 0) {
            this.timerBar.setVisible(true);
            this.timerBar.setMaximum(stepDuration * 4);
            if (!this.timer.isRunning()) {
                this.timer.start();
            }
            this.timerBar.setString(message == null ? "" : message);
        } else {
            if (this.timer.isRunning()) {
                this.timer.stop();
                this.timerBar.setValue(0);
            }
            this.timerBar.setVisible(false);
        }
    }

    void setupProgressBar(int currentStep, int size, String message) {
        this.progressBar.setString(message);
        this.progressBar.setValue(currentStep);
        if (size > 1) {
            this.progressBar.setVisible(true);
            this.progressBar.setMaximum(size);
            this.progressBar.setIndeterminate(false);
        } else {
            this.progressBar.setVisible(message != null);
        }
        this.progressBar.setIndeterminate(this.progressBar.getMaximum() <= 1 && this.progressBar.isVisible() && !this.timerBar.isVisible());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.waitingPanel.stop();
        this.timer.stop();
    }

    static Frame parentFrame() {
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof MainFrame)) continue;
            return frame;
        }
        return null;
    }

    class CancelListener
    extends WindowAdapter
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (WaitingDialog.this.interrupter != null) {
                WaitingDialog.this.interrupter.cancelBackendTask();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WaitingDialog.this.interrupter != null) {
                WaitingDialog.this.interrupter.cancelBackendTask();
            }
        }
    }
}

