/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.waitdlg;

import com.selima.fbi.plugin.IPayrollPluginListener;
import com.selima.fbi.ui.common.waitdlg.AbstractProgressModel;
import com.selima.fbi.ui.common.waitdlg.MailServiceWaiting;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Timer;

public class PluginProgressModel
extends AbstractProgressModel
implements MailServiceWaiting,
IPayrollPluginListener {
    Timer timer;
    long stepStart;
    int currentStep;
    boolean canceled;
    boolean leftToRight;
    String stepMessage;
    String detailMessage;
    List<String> steps = new LinkedList<String>();
    int stepDuration;
    int currentSubstep;
    int numberOfSubsteps;

    public PluginProgressModel(boolean leftToRight) {
        this.leftToRight = leftToRight;
    }

    @Override
    public boolean isLeftToRight() {
        return this.leftToRight;
    }

    @Override
    public synchronized void canceled() {
        this.stepMessage = "Canceling";
        this.stepDuration = 0;
        this.canceled = true;
        this.fireStepChange();
    }

    @Override
    public synchronized void finishedStep(String text) {
        ++this.currentStep;
        this.stepDuration = 0;
        this.numberOfSubsteps = 0;
        this.stepMessage = text;
        this.fireStepChange();
        if (this.timer == null) {
            this.timer = this.createTimer();
        } else {
            this.timer.restart();
        }
    }

    private Timer createTimer() {
        Timer timer = new Timer(2000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                PluginProgressModel pluginProgressModel = PluginProgressModel.this;
                synchronized (pluginProgressModel) {
                    if (!PluginProgressModel.this.canceled) {
                        int index = PluginProgressModel.this.currentStep;
                        if (index < PluginProgressModel.this.steps.size()) {
                            PluginProgressModel.this.stepMessage = PluginProgressModel.this.steps.get(index);
                        }
                        PluginProgressModel.this.fireInstepChange();
                    }
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
        return timer;
    }

    @Override
    public synchronized void reachedSubstep(String text) {
        this.detailMessage = text;
        ++this.currentSubstep;
        this.stepDuration = (int)(System.currentTimeMillis() - this.stepStart) * this.numberOfSubsteps / this.currentSubstep / 1000;
        this.fireInstepChange();
    }

    @Override
    public synchronized void startingStep(int numberOfSubsteps) {
        this.currentSubstep = 0;
        this.numberOfSubsteps = numberOfSubsteps;
        this.stepStart = System.currentTimeMillis();
    }

    @Override
    public synchronized void registerFutureStep(String name) {
        this.steps.add(name);
        if (this.steps.size() == 1) {
            this.stepMessage = name;
            this.fireInstepChange();
        }
    }

    @Override
    public synchronized void registerCurrentStep(String name) {
        this.steps.add(this.currentStep, name);
        if (this.timer == null) {
            this.timer = this.createTimer();
        } else if (!this.timer.isRunning()) {
            this.timer.restart();
        }
        if (this.steps.size() == 1) {
            this.stepMessage = name;
            this.fireInstepChange();
        }
    }

    @Override
    public synchronized void finishedRun() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        this.stepDuration = 0;
        this.currentStep = this.steps.size();
        this.fireStepChange();
    }

    @Override
    public synchronized void registerNumOfRuns(int runs) {
    }

    @Override
    public int getCurrentStep() {
        return this.currentStep;
    }

    @Override
    public String getEventDetail() {
        return this.detailMessage;
    }

    @Override
    public int getNumberOfSteps() {
        return this.steps.size();
    }

    @Override
    public int getStepDuration() {
        return this.stepDuration;
    }

    @Override
    public String getStepMessage() {
        return this.stepMessage;
    }
}

