/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.waitdlg;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.common.waitdlg.AbstractProgressModel;
import com.selima.fbi.ui.export.HTMLExportListener;
import com.selima.fbi.webserver.PagePart;
import java.util.List;

public class HTMLSaveModel
extends AbstractProgressModel
implements HTMLExportListener {
    private int currentIndex;
    private int messageCount;
    private int pageCount;
    private int pageIndex;
    private long messageStartTime;
    private long messageDuration;
    private String message;
    private String detail;

    public HTMLSaveModel(List<? extends IMailMessage> messages) {
        this.messageCount = messages.size();
        this.pageCount = 1;
        this.message = this.messageCount > 1 ? "Saving " + this.messageCount + " messages" : "Saving " + messages.get(0).getSubject();
    }

    @Override
    public void saving(IMailMessage message, List<PagePart> parts) {
        this.message = "Saving " + message.getSubject();
        this.messageStartTime = System.currentTimeMillis();
        this.messageDuration = 0L;
        this.pageCount = parts.size();
        this.pageIndex = 0;
        this.fireStepChange();
    }

    @Override
    public void saved(IMailMessage message) {
        this.message = "Saved " + message.getSubject();
        ++this.currentIndex;
        this.fireStepChange();
    }

    @Override
    public void savedPage(PagePart part) {
        this.detail = "Saved " + part.getName();
        this.messageDuration = System.currentTimeMillis() - this.messageStartTime;
        ++this.pageIndex;
        this.fireInstepChange();
    }

    @Override
    public int getCurrentStep() {
        return this.currentIndex;
    }

    @Override
    public String getStepMessage() {
        return this.message;
    }

    @Override
    public int getNumberOfSteps() {
        return this.messageCount;
    }

    @Override
    public String getEventDetail() {
        return this.detail;
    }

    @Override
    public int getStepDuration() {
        int result = (int)((double)(this.messageDuration * (long)this.pageCount) / (double)this.pageIndex / 1000.0);
        return result;
    }
}

