/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.waitdlg;

import com.selima.fbi.PAYEServiceListener;
import com.selima.fbi.submission.SubmissionState;
import com.selima.fbi.ui.common.waitdlg.AbstractProgressModel;
import com.selima.fbi.ui.common.waitdlg.MailServiceWaiting;
import java.text.ChoiceFormat;
import java.text.MessageFormat;

public abstract class AbstractSubmissionModel
extends AbstractProgressModel
implements PAYEServiceListener,
MailServiceWaiting {
    private static MessageFormat format = new MessageFormat("{0}{1}");
    String message;
    String detail;
    int currentStep;
    protected boolean validation;
    protected int stepDuration;
    protected int pollCount;

    public abstract String actualTitle();

    @Override
    public abstract int getNumberOfSteps();

    protected abstract int stepOf(SubmissionState var1);

    @Override
    public int getCurrentStep() {
        return this.currentStep;
    }

    @Override
    public String getStepMessage() {
        return this.message;
    }

    @Override
    public String getEventDetail() {
        return this.detail;
    }

    @Override
    public int getStepDuration() {
        return this.stepDuration;
    }

    protected final String messageOf(SubmissionState state) {
        String message = "'" + this.actualTitle() + "'";
        switch (state) {
            case LOCAL_VALIDATION: {
                message = "Local validation of " + message;
                break;
            }
            case SENDING: {
                message = this.validation ? "Validating " + message : "Submitting " + message;
                break;
            }
            case POLLING: {
                message = "Polling " + message;
                break;
            }
            case RESPONSE_RECEIVED: {
                message = "Recieved response to " + message;
                break;
            }
            case DELETING_RESPONSE: {
                message = "Clearing " + message + " from Gateway";
                break;
            }
            case ERROR: {
                message = message + " failed";
                break;
            }
            case FINISHED: {
                message = message + " finished";
                break;
            }
        }
        return message;
    }

    @Override
    public void stateChanged(SubmissionState newState, int polling) {
        this.currentStep = this.stepOf(newState);
        this.message = this.messageOf(newState);
        if (newState == SubmissionState.DELETING_RESPONSE || newState == SubmissionState.POLLING) {
            this.stepDuration = polling;
            this.detail = this.pollCountDetail(this.pollCount++);
        } else {
            this.stepDuration = 0;
            this.pollCount = 1;
            this.detail = null;
        }
        this.fireStepChange();
    }

    private String pollCountDetail(int attempt) {
        return format.format(new Object[]{new Integer(attempt), new Integer(attempt % 10)}) + " attempt";
    }

    static {
        format.setFormat(1, new ChoiceFormat("0#th|1#st|2#nd|3#rd|4#th|5#th"));
    }
}

