/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.table;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

abstract class TableMouseInputHandler
implements InvocationHandler {
    private MouseListener lastConsumer;
    private JTable table;

    TableMouseInputHandler(JTable table) {
        this.table = table;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MouseEvent evt = (MouseEvent)args[0];
        int rowIndex = this.table.rowAtPoint(evt.getPoint());
        int columnIndex = this.table.getColumnModel().getColumnIndexAtX(evt.getX());
        if (this.lastConsumer != null && (columnIndex == -1 || this.lastConsumer != this.getMouseListenerAt(rowIndex, columnIndex))) {
            Method mouseExited = MouseListener.class.getMethod("mouseExited", MouseEvent.class);
            mouseExited.invoke((Object)this.lastConsumer, args);
            this.lastConsumer = null;
        }
        if (columnIndex != -1) {
            MouseMotionListener motionListener;
            MouseListener mouseListener = this.getMouseListenerAt(rowIndex, columnIndex);
            if (mouseListener != null && mouseListener != this.lastConsumer && !"mouseEntered".equals(method.getName())) {
                Method mouseEntered = MouseListener.class.getMethod("mouseEntered", MouseEvent.class);
                mouseEntered.invoke((Object)mouseListener, args);
            }
            if (method.getDeclaringClass() == MouseMotionListener.class && (motionListener = this.getMouseMotionListenerAt(rowIndex, columnIndex)) != null) {
                method.invoke((Object)motionListener, args);
            }
            if (method.getDeclaringClass() == MouseListener.class && mouseListener != null) {
                method.invoke((Object)mouseListener, args);
            }
            if (mouseListener != null) {
                this.lastConsumer = "mouseExited".equals(method.getName()) ? null : mouseListener;
            }
        }
        return null;
    }

    protected MouseMotionListener getMouseMotionListenerAt(int row, int column) {
        TableCellRenderer renderer = this.getTableCellRenderer(row, column);
        if (renderer instanceof MouseMotionListener) {
            return (MouseMotionListener)((Object)renderer);
        }
        return null;
    }

    private MouseListener getMouseListenerAt(int row, int column) {
        TableCellRenderer renderer = this.getTableCellRenderer(row, column);
        if (renderer instanceof MouseListener) {
            return (MouseListener)((Object)renderer);
        }
        return null;
    }

    protected abstract TableCellRenderer getTableCellRenderer(int var1, int var2);
}

