/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.table;

import com.selima.fbi.ui.common.table.ContentTable;
import com.selima.fbi.ui.common.table.OriginalHeaderTableRenderer;
import com.selima.fbi.ui.common.table.SortIconFactory;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

class SortingHeaderRenderer
extends OriginalHeaderTableRenderer
implements MouseListener {
    SortingHeaderRenderer(ContentTable table) {
        super(table.getTableHeader());
        super.setBorder(new LeftMarginBorder(this.getBorder()));
        this.setFont(UIManager.getFont("TableHeader.font").deriveFont(1));
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(new LeftMarginBorder(border));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ContentTable fbiTable = (ContentTable)table;
        int modelIndex = fbiTable.getColumnModel().getColumn(column).getModelIndex();
        int sortIndex = fbiTable.getModel().sortOrderOf(modelIndex);
        if (sortIndex != -1) {
            this.setIcon(SortIconFactory.getSortedIcon(sortIndex, fbiTable.getModel().isSortAscending(modelIndex)));
        } else {
            this.setIcon(SortIconFactory.getUnsortedIcon());
        }
        this.setText(value.toString());
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        JTableHeader tableHeader = (JTableHeader)evt.getComponent();
        ContentTable fbiTable = (ContentTable)tableHeader.getTable();
        int index = fbiTable.columnAtPoint(evt.getPoint());
        if (index != -1) {
            TableColumn column = fbiTable.getColumnModel().getColumn(index);
            int modelIndex = column.getModelIndex();
            fbiTable.getModel().sort(modelIndex);
            fbiTable.invokeSorting();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    static class LeftMarginBorder
    extends CompoundBorder {
        LeftMarginBorder(Border outsideBorder) {
            this.insideBorder = BorderFactory.createEmptyBorder(0, 5, 0, 0);
            this.outsideBorder = outsideBorder == null || outsideBorder instanceof LeftMarginBorder ? BorderFactory.createEmptyBorder(1, 1, 1, 1) : outsideBorder;
        }
    }
}

