/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.table;

import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.common.FocusFixTable;
import com.selima.fbi.ui.common.PopupOwner;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.table.ContentTableColumn;
import com.selima.fbi.ui.common.table.ContentTableColumnModel;
import com.selima.fbi.ui.common.table.RowTableModel;
import com.selima.fbi.ui.common.table.RowTableModelColumn;
import com.selima.fbi.ui.common.table.SortingHeaderRenderer;
import com.selima.fbi.ui.common.table.TableMouseInputHandler;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import java.awt.Component;
import java.awt.Point;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class ContentTable
extends FocusFixTable
implements PopupOwner {
    JPopupMenu menu;
    Point popupPoint;
    protected ClientContext cctx;
    ContentTableColumnModel desiredColumnModel;

    public ContentTable(ClientContext cctx, RowTableModel model) {
        super(model);
        this.cctx = cctx;
        this.menu = new JPopupMenu();
        MouseInputListener mouseHandler = this.delegatingMouseInputHandler();
        this.getTableHeader().addMouseListener(mouseHandler);
        this.getTableHeader().addMouseMotionListener(mouseHandler);
        this.getTableHeader().setDefaultRenderer(new SortingHeaderRenderer(this));
        SwingHelper.installPopupTrigger(this, this);
        this.menu.addPopupMenuListener(new PopupCloser());
    }

    public ContentTableColumnModel getContentTableColumnModel() {
        return (ContentTableColumnModel)this.getColumnModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContentTableColumnModel(ContentTableColumnModel model) {
        RowTableModelColumn[] columns = new RowTableModelColumn[model.getColumnCount()];
        int i = 0;
        for (ContentTableColumn column : model) {
            columns[i++] = column.getTableModelColumn();
        }
        this.desiredColumnModel = model;
        try {
            this.getModel().setColumns(columns);
        }
        finally {
            this.desiredColumnModel = null;
        }
    }

    @Override
    public void popupTriggered(JComponent source, Point mousePoint) {
        this.popupPoint = mousePoint;
        if (this.popupPoint == null) {
            int row = this.getSelectionModel().getLeadSelectionIndex();
            int column = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (row >= 0 && row < this.getRowCount() && column >= 0 && column < this.getColumnCount()) {
                this.popupPoint = this.getCellRect(row, column, false).getLocation();
                this.popupPoint.translate(2, this.getRowHeight(row) - 2);
            } else {
                this.popupPoint = new Point(2, this.getRowHeight() - 2);
            }
        }
        JPopupMenu popupMenu = this.getPopupMenu();
        popupMenu.show(source, this.popupPoint.x, this.popupPoint.y);
    }

    public Point getPopupPoint() {
        return this.popupPoint;
    }

    @Override
    public RowTableModel getModel() {
        return (RowTableModel)super.getModel();
    }

    public JPopupMenu getPopupMenu() {
        for (Component c : this.menu.getComponents()) {
            JMenuItem item;
            if (!(c instanceof JMenuItem) || (item = (JMenuItem)c).getAction() == null) continue;
            item.setEnabled(item.getAction().isEnabled());
        }
        return this.menu;
    }

    public void invokeSorting() {
        this.cctx.getSubmitter().submitWork(new BackendWork(){

            public String getName() {
                return "Sorting table";
            }

            public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
                ContentTable.this.getModel().invokeSorting();
            }

            public void invokeSwing(SwingOperationHandle handle) {
                ContentTable.this.getModel().fireTableDataChanged();
            }
        });
    }

    @Override
    public void createDefaultColumnsFromModel() {
        if (this.desiredColumnModel != null) {
            super.setColumnModel(this.desiredColumnModel);
        } else {
            super.setColumnModel(new ContentTableColumnModel(this.getModel().getColumns(), this.getColumnModel()));
        }
    }

    public void loadColumnModel() {
        ContentTableColumnModel columnModel = this.load("columns", this.getModel().getMapOfColumns());
        if (columnModel != null) {
            this.setContentTableColumnModel(columnModel);
        }
    }

    public void saveColumnModel() {
        this.save("columns", this.getContentTableColumnModel());
    }

    MouseInputListener delegatingMouseInputHandler() {
        return (MouseInputListener)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MouseInputListener.class}, (InvocationHandler)new HeaderRendererMouseInputHandler());
    }

    protected ContentTableColumnModel load(String key, Map<String, RowTableModelColumn<?>> mapOfColumns) {
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String string = prefs.get(key, null);
        if (string != null) {
            String[] pieces = string.split("\n");
            ArrayList columns = new ArrayList(pieces.length);
            ArrayList<Integer> widths = new ArrayList<Integer>(pieces.length);
            for (String piece : pieces) {
                try {
                    String[] parts = piece.split("\t");
                    RowTableModelColumn<?> column = mapOfColumns.get(parts[0]);
                    if (column == null) {
                        return null;
                    }
                    columns.add(column);
                    widths.add(Integer.parseInt(parts[1]));
                }
                catch (NullPointerException e) {
                    return null;
                }
                catch (NumberFormatException e) {
                    return null;
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
            ContentTableColumnModel result = new ContentTableColumnModel(columns.toArray(new RowTableModelColumn[columns.size()]));
            Iterator widthsIterator = widths.iterator();
            for (ContentTableColumn column : result) {
                Integer width = (Integer)widthsIterator.next();
                column.setPreferredWidth(width);
            }
            return result;
        }
        return null;
    }

    protected void save(String key, ContentTableColumnModel columnModel) {
        StringBuilder text = new StringBuilder();
        int overalWidth = 0;
        int preferredWidth = 0;
        for (Object column : columnModel) {
            preferredWidth += ((TableColumn)column).getPreferredWidth();
            overalWidth += ((TableColumn)column).getWidth();
        }
        int diff = (preferredWidth - overalWidth) / columnModel.getColumnCount();
        for (ContentTableColumn column : columnModel) {
            text.append(column.getTableModelColumn().getTitle()).append('\t').append(column.getWidth() + diff).append('\n');
        }
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        prefs.put(key, text.toString());
    }

    private class HeaderRendererMouseInputHandler
    extends TableMouseInputHandler {
        HeaderRendererMouseInputHandler() {
            super(ContentTable.this);
        }

        @Override
        protected TableCellRenderer getTableCellRenderer(int row, int column) {
            TableCellRenderer renderer = ContentTable.this.getColumnModel().getColumn(column).getHeaderRenderer();
            if (renderer == null) {
                renderer = ContentTable.this.getTableHeader().getDefaultRenderer();
            }
            return renderer;
        }
    }

    private final class PopupCloser
    implements PopupMenuListener,
    Runnable {
        private PopupCloser() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void run() {
            ContentTable.this.popupPoint = null;
        }
    }
}

