/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.popup;

import com.selima.fbi.ui.common.popup.CompoundPopupBorder;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class PopupWindow
extends JWindow {
    JComponent anchorComponent;
    JComponent popupContent;
    Relocator relocator;
    int xOffset = 0;
    int yOffset = 0;

    public PopupWindow(JFrame frame, JComponent owner, JComponent contents) {
        super(frame);
        this.anchorComponent = owner;
        this.popupContent = contents;
        this.relocator = new Relocator();
        this.setFocusableWindowState(true);
        this.setContentPane(this.popupContent);
        this.setFocusable(true);
        try {
            Class<?> awtUtilities = Class.forName("com.sun.awt.AWTUtilities");
            awtUtilities.getMethod("setWindowOpaque", Window.class, Boolean.TYPE).invoke(null, this, false);
        }
        catch (Exception ex) {
            this.setBackground(SystemColor.desktop);
        }
        contents.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "Escape");
        contents.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "Escape");
        contents.getActionMap().put("Escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupWindow.this.setVisible(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PopupWindow.this.anchorComponent.requestFocusInWindow();
                    }
                });
            }
        });
        JRootPane rootPane = this.getRootPane();
        rootPane.setBorder(new CompoundPopupBorder(contents.getBackground()));
        CaptionMouseListener captionMouseListener = new CaptionMouseListener();
        rootPane.addMouseMotionListener(captionMouseListener);
        rootPane.addMouseListener(captionMouseListener);
    }

    public void flip() {
        if (this.isVisible()) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    public void setOffset(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            Dimension buttonSize = this.anchorComponent.getSize();
            this.setOffset(-this.popupContent.getPreferredSize().width / 2 + buttonSize.width / 2, buttonSize.height - 5);
            this.relocate();
            this.relocator.attach();
        } else {
            this.relocator.detach();
        }
        super.setVisible(state);
        if (state) {
            this.getContentPane().getFocusCycleRootAncestor().getFocusTraversalPolicy().getDefaultComponent(this.getContentPane()).requestFocusInWindow();
        }
    }

    public void relocate() {
        Point popupPoint = new Point(this.xOffset, this.yOffset);
        SwingUtilities.convertPointToScreen(popupPoint, this.anchorComponent);
        Dimension popupSize = this.getRootPane().getPreferredSize();
        this.setBounds(new Rectangle(popupPoint, popupSize));
    }

    class Relocator
    implements PropertyChangeListener,
    AncestorListener {
        Relocator() {
        }

        void attach() {
            PopupWindow.this.popupContent.addPropertyChangeListener(this);
            PopupWindow.this.anchorComponent.addAncestorListener(this);
        }

        void detach() {
            PopupWindow.this.popupContent.removePropertyChangeListener(this);
            PopupWindow.this.anchorComponent.removeAncestorListener(this);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            if (PopupWindow.this.isVisible()) {
                PopupWindow.this.setVisible(false);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            PopupWindow.this.relocate();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("preferredSize".equals(evt.getPropertyName())) {
                PopupWindow.this.relocate();
            }
        }
    }

    class CaptionMouseListener
    extends MouseAdapter {
        Point lastDragPoint;

        CaptionMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Rectangle rec;
            JComponent source = (JComponent)evt.getComponent();
            CompoundPopupBorder border = (CompoundPopupBorder)source.getBorder();
            if (border.getButtonBounds(source).contains(evt.getPoint())) {
                border.setButtonPressOffset(true);
                source.repaint();
            }
            if ((rec = new Rectangle(PopupWindow.this.getWidth(), source.getInsets().top)).contains(evt.getPoint())) {
                this.lastDragPoint = evt.getLocationOnScreen();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.lastDragPoint != null) {
                Point diff = e.getLocationOnScreen();
                diff.translate(-this.lastDragPoint.x, -this.lastDragPoint.y);
                PopupWindow.this.xOffset += diff.x;
                PopupWindow.this.yOffset += diff.y;
                Point location = PopupWindow.this.getLocation();
                location.translate(diff.x, diff.y);
                PopupWindow.this.setLocation(location);
                this.lastDragPoint = e.getLocationOnScreen();
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            JComponent source = (JComponent)evt.getComponent();
            CompoundPopupBorder border = (CompoundPopupBorder)source.getBorder();
            if (border.getButtonBounds(source).contains(evt.getPoint())) {
                PopupWindow.this.setVisible(false);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            JComponent source = (JComponent)evt.getComponent();
            CompoundPopupBorder border = (CompoundPopupBorder)source.getBorder();
            border.setButtonPressOffset(false);
            source.repaint();
            this.lastDragPoint = null;
        }
    }
}

