/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.popup;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import javax.swing.border.Border;

class PopupBorder
implements Border {
    static final Insets INSETS = new Insets(20, 2, 6, 6);
    static final Color CAPTION_COLOR;
    static final Color SHADOW_COLOR;
    int buttonY = 6;
    int buttonW = 8;
    int buttonH = 8;

    PopupBorder() {
    }

    void setButtonPressOffset(boolean state) {
        this.buttonY = state ? 8 : 6;
    }

    Rectangle getButtonBounds(Component c) {
        return new Rectangle(this.buttonX(c), this.buttonY, this.buttonW, this.buttonH);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(CAPTION_COLOR);
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, CAPTION_COLOR, width, 0.0f, SystemColor.activeCaption);
        g2d.setPaint(gradient);
        Object oldValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.fillArc(c.getWidth() - 2 * PopupBorder.INSETS.top - PopupBorder.INSETS.right + 1, 0, 2 * PopupBorder.INSETS.top, 2 * PopupBorder.INSETS.top, 0, 90);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValue);
        g2d.fillRect(0, 0, c.getWidth() - PopupBorder.INSETS.top - PopupBorder.INSETS.right + 1, PopupBorder.INSETS.top);
        g2d.fillRect(0, 0, PopupBorder.INSETS.left, c.getHeight() - PopupBorder.INSETS.bottom);
        g2d.drawLine(0, c.getHeight() - PopupBorder.INSETS.bottom, c.getWidth() - PopupBorder.INSETS.right, c.getHeight() - PopupBorder.INSETS.bottom);
        g2d.drawLine(c.getWidth() - PopupBorder.INSETS.right, PopupBorder.INSETS.top, c.getWidth() - PopupBorder.INSETS.right, c.getHeight() - PopupBorder.INSETS.bottom);
        g.setColor(SHADOW_COLOR);
        g.fillRect(c.getWidth() - PopupBorder.INSETS.right, PopupBorder.INSETS.top, PopupBorder.INSETS.right, c.getHeight() - PopupBorder.INSETS.bottom);
        g.fillRect(0, c.getHeight() - PopupBorder.INSETS.bottom, c.getWidth() - PopupBorder.INSETS.right, PopupBorder.INSETS.bottom);
        g2d.setColor(Color.WHITE);
        g2d.setStroke(new BasicStroke(2.5f, 1, 2, 1.0f));
        g2d.drawLine(this.buttonX(c), this.buttonY, this.buttonX(c) + this.buttonW, this.buttonY + this.buttonH);
        g2d.drawLine(this.buttonX(c), this.buttonY + this.buttonH, this.buttonX(c) + this.buttonW, this.buttonY);
    }

    private int buttonX(Component c) {
        return c.getWidth() - 3 * PopupBorder.INSETS.right - 3 - this.buttonW;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    static {
        SHADOW_COLOR = new Color(15, 80, 161, 32);
        SystemColor c = SystemColor.activeCaption;
        CAPTION_COLOR = new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
    }
}

