/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Icon;

public class SortIcon
implements Icon {
    public static final int NONE = 0;
    public static final int DECENDING = 1;
    public static final int ASCENDING = 2;
    protected int direction;
    protected int width;
    protected int height;

    public SortIcon(int direction, int size) {
        this.direction = direction;
        this.width = this.height = size;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x1, int y1) {
        Color bg = c.getBackground();
        if (bg == null) {
            bg = SystemColor.control;
        }
        Color light = bg.brighter();
        Color shade = bg.darker();
        int median = x1 + this.width / 2;
        int y2 = y1 + this.height;
        int x2 = x1 + this.width;
        switch (this.direction) {
            case 2: {
                g.setColor(shade);
                g.drawLine(x1, y1, x2, y1);
                g.drawLine(x1, y1, median, y2);
                g.setColor(light);
                g.drawLine(x2, y1, median, y2);
                break;
            }
            case 1: {
                g.setColor(shade);
                g.drawLine(median, y1, x1, y2);
                g.setColor(light);
                g.drawLine(x1, y2, x2, y2);
                g.drawLine(median, y1, x2, y2);
            }
        }
    }
}

