/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.ui.common.ExtensionFilter;
import com.selima.fbi.ui.common.FBIFileChooser;
import com.selima.fbi.ui.common.FileFormatAccessory;
import com.selima.fbi.util.IOUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;

public class FormatFileChooser
extends FBIFileChooser {
    boolean manyHtmlPages;

    public FormatFileChooser() {
        this(new FileFormatAccessory());
    }

    FormatFileChooser(FileFormatAccessory accessory) {
        super(accessory);
        this.setDialogTitle("Select export file");
        this.setFileSelectionMode(2);
        this.setCurrentDirectory(this.getSaveDir());
        this.setFileFilter(new ExtensionFilter(Arrays.asList(".xml", ".html", ".htm")));
        this.getAccessory().addPropertyChangeListener("xml", new FormatHandler());
    }

    public void setProposedBaseName(String fileName) {
        File file = new File(this.getCurrentDirectory(), fileName + (this.isXml() ? ".xml" : ".html"));
        this.setSelectedFile(file);
    }

    public boolean isManyHtmlPages() {
        return this.manyHtmlPages;
    }

    public void setManyHtmlPages(boolean state) {
        this.manyHtmlPages = state;
    }

    File mask(File file) {
        String baseName = IOUtil.stripExtension(file);
        if (!baseName.contains("%page%")) {
            if (!baseName.endsWith("-")) {
                baseName = baseName + '-';
            }
            baseName = baseName + "%page%";
            file = new File(file.getParentFile(), baseName + IOUtil.getExtension(file));
        }
        return file;
    }

    File unmask(File file) {
        String baseName = IOUtil.stripExtension(file);
        if (baseName.contains("%page%")) {
            baseName = baseName.replaceAll("\\-%page%", "");
            baseName = baseName.replaceAll("\\%page%", "");
            file = new File(file.getParentFile(), baseName + IOUtil.getExtension(file));
        }
        return file;
    }

    @Override
    public void setSelectedFile(File file) {
        if (file != null && !file.isDirectory()) {
            file = this.isHtml() && this.isManyHtmlPages() ? this.mask(file) : this.unmask(file);
        }
        super.setSelectedFile(file);
        if (file != null) {
            this.setSaveDir(file.getParentFile());
            this.getAccessory().selectExtension(file);
        }
    }

    class FormatHandler
    implements PropertyChangeListener {
        FormatHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            File file = FormatFileChooser.this.getSelectedFile();
            if (file != null && !file.isDirectory()) {
                file = FormatFileChooser.this.isXml() ? IOUtil.setExtension(file, ".xml") : IOUtil.setExtension(file, ".html");
                FormatFileChooser.this.setSelectedFile(file);
            }
        }
    }
}

