/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.user.IFullReference;
import com.selima.fbi.user.IReferenceManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;

public class EmpRefCellRenderer
implements TableCellRenderer,
ListCellRenderer {
    final TableCellRenderer tableCellRenderer;
    final ListCellRenderer listCellRenderer;
    final IReferenceManager referenceManager;

    public EmpRefCellRenderer(IReferenceManager referenceManager, TableCellRenderer renderer) {
        this.referenceManager = referenceManager;
        this.tableCellRenderer = renderer;
        this.listCellRenderer = null;
    }

    public EmpRefCellRenderer(IReferenceManager referenceManager, ListCellRenderer listCellRenderer) {
        this.tableCellRenderer = null;
        this.listCellRenderer = listCellRenderer;
        this.referenceManager = referenceManager;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.tableCellRenderer.getTableCellRendererComponent(table, this.toHtml(value), isSelected, hasFocus, row, column);
    }

    protected Object toHtml(Object value) {
        if (value == null) {
            return value;
        }
        IFullReference ref = this.referenceManager.getFullReference((String)value);
        String description = ref.getDescription();
        if (description == null) {
            description = "";
        }
        return "<html><table width='1024'><tr><td width='85'><b>" + value + "</b></td><td width='939'nowrap>" + description + "</td></tr></table></html>";
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent result = (JComponent)this.listCellRenderer.getListCellRendererComponent(list, this.toHtml(value), index, isSelected, cellHasFocus);
        Dimension size = result.getPreferredSize();
        size.width = 200;
        result.setPreferredSize(size);
        return result;
    }
}

