/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.ui.common.AbstractKeyAction;
import com.selima.fbi.ui.common.Constraint;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DatePopupDialog
extends JDialog {
    private static final Color MONTH_BACKGROUND = Color.WHITE;
    private static final Color MONTH_FOREGROUND = Color.BLACK;
    private static final Color OTHER_BACKGROUND = null;
    private static final Color OTHER_FOREGROUND = null;
    private static final Color SELECTED_BACKGROUND = Color.BLUE;
    private static final Color SELECTED_FOREGROUND = Color.WHITE;

    public DatePopupDialog(JFrame parentWindow, String title) {
        super(parentWindow, title, true);
        this.setDefaultCloseOperation(1);
        DialogPanel dialogPanel = new DialogPanel(null);
        this.setContentPane(dialogPanel);
        this.setFocusTraversalPolicy(dialogPanel.createTraversalPolicy());
        this.pack();
        this.setLocationRelativeTo(parentWindow);
    }

    public Date popup(Date d) {
        DialogPanel dlgPanel = (DialogPanel)this.getContentPane();
        dlgPanel.setDate(d);
        this.setVisible(true);
        return dlgPanel.getDate();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("net.java.plaf.windows.WindowsLookAndFeel");
            UIManager.put("Table.focusCellBackground", new Color(225, 225, 255));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        Date result = new DatePopupDialog(null, "Blaab;la").popup(new Date());
        System.out.println(result);
        System.exit(0);
    }

    static abstract class AbstractModel
    implements ComboBoxModel {
        protected Object selectedItem;
        protected ArrayList<String> data;
        protected boolean internalChange = false;
        protected EventBroadcast<ListDataListener> listDataListeners = EventBroadcastFactory.createEventBroadcast(ListDataListener.class);
        protected EventBroadcast<ComboBoxExternalChangeListener> externalChangeListeners = EventBroadcastFactory.createEventBroadcast(ComboBoxExternalChangeListener.class);

        protected AbstractModel(ArrayList<String> data) {
            this.data = data;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.equals(this.selectedItem, anItem)) {
                return;
            }
            this.selectedItem = anItem;
            ((ListDataListener)this.listDataListeners.getListener()).contentsChanged(new ListDataEvent(this, 0, -1, -1));
            if (!this.internalChange) {
                ((ComboBoxExternalChangeListener)this.externalChangeListeners.getListener()).externalSelectionChange(new ExternalSelectionEvent(this, this.externalValue(this.selectedItem)));
            }
        }

        protected abstract int externalValue(Object var1);

        public abstract void selectItemInternally(int var1);

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listDataListeners.addListener((Object)l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listDataListeners.removeListener((Object)l);
        }

        public void addExternalChangeListener(ComboBoxExternalChangeListener l) {
            this.externalChangeListeners.addListener((Object)l);
        }

        public void removeExternalChangeListener(ComboBoxExternalChangeListener l) {
            this.externalChangeListeners.removeListener((Object)l);
        }

        protected final boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }
    }

    static class YearModel
    extends AbstractModel {
        protected YearModel(Calendar cal) {
            super(new ArrayList<String>(10));
            int currentYear = cal.get(1);
            for (int i = currentYear - 3; i < currentYear + 4; ++i) {
                this.data.add(String.valueOf(i));
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            try {
                Integer.parseInt((String)anItem);
            }
            catch (NumberFormatException e) {
                ((ListDataListener)this.listDataListeners.getListener()).contentsChanged(new ListDataEvent(this, 0, -1, -1));
                return;
            }
            super.setSelectedItem(anItem);
            int pos = this.data.indexOf(anItem);
            if (pos <= 1 || pos >= this.data.size() - 2) {
                this.data.clear();
                int currentYear = Integer.parseInt((String)anItem);
                for (int i = currentYear - 3; i < currentYear + 4; ++i) {
                    this.data.add(String.valueOf(i));
                }
                ((ListDataListener)this.listDataListeners.getListener()).contentsChanged(new ListDataEvent(this, 0, 0, this.data.size()));
            }
        }

        @Override
        protected int externalValue(Object anItem) {
            return Integer.parseInt((String)anItem);
        }

        @Override
        public void selectItemInternally(int year) {
            this.internalChange = true;
            this.setSelectedItem(String.valueOf(year));
            this.internalChange = false;
        }
    }

    static class MonthModel
    extends AbstractModel {
        protected MonthModel() {
            super(new ArrayList<String>(12));
            SimpleDateFormat format = new SimpleDateFormat("MMMM");
            GregorianCalendar cal = new GregorianCalendar();
            for (int i = 0; i < 12; ++i) {
                cal.set(2, i);
                this.data.add(format.format(cal.getTime()));
            }
        }

        @Override
        protected int externalValue(Object anItem) {
            return this.data.indexOf(anItem);
        }

        @Override
        public void selectItemInternally(int month) {
            this.internalChange = true;
            this.setSelectedItem(this.data.get(month));
            this.internalChange = false;
        }
    }

    public static class ExternalSelectionEvent {
        public AbstractModel source;
        public int value;

        public ExternalSelectionEvent(AbstractModel source, int value) {
            this.source = source;
            this.value = value;
        }
    }

    public static interface ComboBoxExternalChangeListener {
        public void externalSelectionChange(ExternalSelectionEvent var1);
    }

    static class ButtonRenderer
    extends MouseAdapter
    implements FocusListener {
        private static final Color bckgFocus = new Color(0.1f, 0.1f, 0.66f);
        private static final Color fgFocus = Color.WHITE;
        private static final Color bckgMouse = new Color(0.66f, 0.1f, 0.1f);
        private static final Color fgMouse = Color.WHITE;
        private Color bckgcolor;
        private Color fgcolor;
        private boolean inMouseAction;
        private boolean inFocusAction;

        public ButtonRenderer(JButton button) {
            button.addMouseListener(this);
            button.addFocusListener(this);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            if (!this.inFocusAction) {
                this.inMouseAction = true;
                this.bckgcolor = evt.getComponent().getBackground();
                this.fgcolor = evt.getComponent().getForeground();
                evt.getComponent().setForeground(fgMouse);
                evt.getComponent().setBackground(bckgMouse);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (this.inMouseAction) {
                this.inMouseAction = false;
                evt.getComponent().setBackground(this.bckgcolor);
                evt.getComponent().setForeground(this.fgcolor);
            }
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (!this.inMouseAction) {
                this.inFocusAction = true;
                this.bckgcolor = evt.getComponent().getBackground();
                this.fgcolor = evt.getComponent().getForeground();
                evt.getComponent().setForeground(fgFocus);
                evt.getComponent().setBackground(bckgFocus);
                evt.getComponent().repaint();
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            if (this.inFocusAction) {
                this.inFocusAction = false;
                evt.getComponent().setBackground(this.bckgcolor);
                evt.getComponent().setForeground(this.fgcolor);
            }
        }
    }

    public class DialogPanel
    extends JPanel
    implements WindowListener,
    PropertyChangeListener,
    ComboBoxExternalChangeListener {
        private DateFormat format;
        private Calendar calendar;
        private Date actualDate;
        private Date exportDate;
        private JLabel lblActualDate;
        private AbstractModel monthModel;
        private AbstractModel yearModel;
        private DateButton[] buttons;
        private Action okAction;
        private Action cancelAction;

        DialogPanel(Date date) {
            super(new GridBagLayout());
            this.format = DateFormat.getDateInstance(0);
            this.actualDate = date == null ? new Date() : date;
            this.okAction = new OKAction();
            this.cancelAction = new CancelAction();
            this.calendar = Calendar.getInstance();
            DatePopupDialog.this.addWindowListener(this);
            this.addPropertyChangeListener(this);
            this.calendar.setTime(this.actualDate);
            this.monthModel = new MonthModel();
            this.monthModel.selectItemInternally(this.calendar.get(2));
            this.monthModel.addExternalChangeListener(this);
            this.yearModel = new YearModel(this.calendar);
            this.yearModel.selectItemInternally(this.calendar.get(1));
            this.yearModel.addExternalChangeListener(this);
            KeyStroke cancelKeyStroke = KeyStroke.getKeyStroke('\u001b');
            KeyStroke okKeyStroke = KeyStroke.getKeyStroke('\n');
            InputMap inputMap = this.getInputMap(2);
            ActionMap actionMap = this.getActionMap();
            inputMap.put(cancelKeyStroke, "cancel");
            inputMap.put(okKeyStroke, "ok");
            actionMap.put("cancel", this.cancelAction);
            actionMap.put("ok", this.okAction);
            this.buildLayout();
        }

        private void buildLayout() {
            int i;
            String[] daysOfWeek = this.getWeekDayNames(this.calendar);
            this.lblActualDate = new JLabel(this.format.format(this.actualDate));
            this.lblActualDate.setOpaque(true);
            this.lblActualDate.setBackground(MONTH_BACKGROUND);
            this.lblActualDate.setHorizontalAlignment(0);
            this.lblActualDate.setFont(this.lblActualDate.getFont().deriveFont(1).deriveFont(18.0f));
            this.add((Component)this.lblActualDate, Constraint.create(0, 0, daysOfWeek.length, 1).insets(5, 5, 5, 5).fill(1));
            JComboBox cbxMonth = new JComboBox(this.monthModel);
            this.add(cbxMonth, Constraint.create(0, 1, daysOfWeek.length - daysOfWeek.length / 2, 1).fill(1));
            JComboBox cbxYear = new JComboBox(this.yearModel);
            cbxYear.setEditable(true);
            this.add(cbxYear, Constraint.create(4, 1, daysOfWeek.length / 2, 1).fill(1));
            for (int i2 = 0; i2 < daysOfWeek.length; ++i2) {
                JLabel label = new JLabel(daysOfWeek[i2]);
                label.setFont(label.getFont().deriveFont(1));
                Dimension d = label.getPreferredSize();
                label.setHorizontalAlignment(0);
                this.add((Component)label, Constraint.create(i2, 2, 1, 1).fill(1).weight(1.0, 0.0));
            }
            Date[] monthDates = this.getMonthDates(this.actualDate, this.calendar);
            this.buttons = new DateButton[monthDates.length];
            for (i = 0; i < monthDates.length; ++i) {
                this.buttons[i] = new DateButton(monthDates[i]);
                this.add((Component)this.buttons[i], Constraint.create(i % daysOfWeek.length, i / daysOfWeek.length + 3, 1, 1).fill(1).weight(0.0, 1.0));
            }
            for (i = 0; i < this.buttons.length; ++i) {
                new KeyNavigationAction("UP", this.buttons[i], this.buttons[(i + this.buttons.length - 7) % this.buttons.length]);
                new KeyNavigationAction("LEFT", this.buttons[i], this.buttons[(i + this.buttons.length - 1) % this.buttons.length]);
                new KeyNavigationAction("DOWN", this.buttons[i], this.buttons[(i + 7) % this.buttons.length]);
                new KeyNavigationAction("RIGHT", this.buttons[i], this.buttons[(i + 1) % this.buttons.length]);
            }
            this.add((Component)new JButton(this.cancelAction), Constraint.create(0, -1, daysOfWeek.length, 1).fill(0).anchor(10).insets(7, 5, 7, 5));
            this.setPreferredSize(new Dimension(240, 240));
        }

        FocusTraversalPolicy createTraversalPolicy() {
            return new DialogPanelTraversalPolicy();
        }

        public void setDate(Date exportDate) {
            if (!this.equals(this.exportDate, exportDate)) {
                Date oldValue = this.exportDate;
                this.exportDate = exportDate;
                if (exportDate != null) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(exportDate);
                    this.monthModel.selectItemInternally(cal.get(2));
                    this.yearModel.selectItemInternally(cal.get(1));
                }
                this.firePropertyChange("date", oldValue, exportDate);
            }
        }

        public Date getDate() {
            return this.exportDate;
        }

        protected void setActualDate(Date date) {
            if (!this.equals(date, this.actualDate)) {
                Date oldValue = this.actualDate;
                this.actualDate = date;
                this.firePropertyChange("actualDate", oldValue, date);
            }
        }

        protected Date getActualDate() {
            return this.actualDate;
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.setDate(null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("date".equals(propertyName)) {
                if (evt.getNewValue() != null) {
                    this.setActualDate((Date)evt.getNewValue());
                }
            } else if ("actualDate".equals(propertyName)) {
                Date oldDate;
                Date newDate = (Date)evt.getNewValue();
                if (!this.sameMonth(newDate, oldDate = (Date)evt.getOldValue(), this.calendar)) {
                    this.displayMonth(newDate);
                } else {
                    this.selectDay(newDate);
                }
                this.lblActualDate.setText(this.format.format(newDate));
            }
        }

        @Override
        public void externalSelectionChange(ExternalSelectionEvent evt) {
            this.calendar.setTime(this.actualDate);
            if (evt.source == this.monthModel) {
                this.calendar.set(2, evt.value);
            } else if (evt.source == this.yearModel) {
                this.calendar.set(1, evt.value);
            }
            this.setActualDate(this.calendar.getTime());
        }

        private void displayMonth(Date d) {
            Date[] dates = this.getMonthDates(d, this.calendar);
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].setDate(dates[i]);
            }
        }

        private void selectDay(Date d) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].chooseColors();
            }
        }

        protected final boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }

        protected boolean sameMonth(Date d1, Date d2, Calendar calendar) {
            boolean result = false;
            if (d1 != null & d2 != null) {
                calendar.setTime(d1);
                int m1 = calendar.get(2);
                int y1 = calendar.get(1);
                calendar.setTime(d2);
                int m2 = calendar.get(2);
                int y2 = calendar.get(1);
                result = m1 == m2 && y1 == y2;
            }
            return result;
        }

        protected boolean sameDay(Date date1, Date date2, Calendar calendar) {
            boolean result = false;
            if (date1 != null & date2 != null) {
                calendar.setTime(date1);
                int m1 = calendar.get(2);
                int y1 = calendar.get(1);
                int d1 = calendar.get(5);
                calendar.setTime(date2);
                int m2 = calendar.get(2);
                int y2 = calendar.get(1);
                int d2 = calendar.get(5);
                result = d1 == d2 && m1 == m2 && y1 == y2;
            }
            return result;
        }

        protected Date[] getMonthDates(Date date, Calendar calendar) {
            Date[] result = new Date[35];
            calendar.setTime(date);
            calendar.set(5, 1);
            while (calendar.get(7) != calendar.getFirstDayOfWeek()) {
                calendar.add(5, -1);
            }
            for (int i = 0; i < result.length; ++i) {
                result[i] = calendar.getTime();
                calendar.add(5, 1);
            }
            return result;
        }

        protected String[] getWeekDayNames(Calendar calendar) {
            SimpleDateFormat format = new SimpleDateFormat("EEE");
            String[] result = new String[calendar.getMaximum(7)];
            calendar.set(7, calendar.getFirstDayOfWeek());
            for (int i = 0; i < result.length; ++i) {
                result[i] = format.format(calendar.getTime());
                calendar.add(7, 1);
            }
            return result;
        }

        class DateButton
        extends JButton {
            private Color defaultForeground;
            private Color defaultBackground;

            DateButton(Date date) {
                this.setAction(new DateAction(date));
                this.defaultForeground = this.getForeground();
                this.defaultBackground = this.getBackground();
                this.setMinimumSize(new Dimension(50, 50));
                this.setPreferredSize(new Dimension(50, 50));
                this.setContentAreaFilled(false);
                this.setOpaque(true);
                this.setBorder(new SoftBevelBorder(1));
                new ButtonRenderer(this);
            }

            @Override
            public DateAction getAction() {
                return (DateAction)super.getAction();
            }

            void setDate(Date date) {
                this.getAction().setDate(date);
                this.chooseColors();
            }

            Date getDate() {
                return this.getAction().getDate();
            }

            void chooseColors() {
                if (DialogPanel.this.sameDay(this.getDate(), DialogPanel.this.getActualDate(), DialogPanel.this.calendar)) {
                    this.setForeground(SELECTED_FOREGROUND == null ? this.defaultForeground : SELECTED_FOREGROUND);
                    this.setBackground(SELECTED_BACKGROUND == null ? this.defaultBackground : SELECTED_BACKGROUND);
                } else if (DialogPanel.this.sameMonth(this.getDate(), DialogPanel.this.getActualDate(), DialogPanel.this.calendar)) {
                    this.setForeground(MONTH_FOREGROUND == null ? this.defaultForeground : MONTH_FOREGROUND);
                    this.setBackground(MONTH_BACKGROUND == null ? this.defaultBackground : MONTH_BACKGROUND);
                } else {
                    this.setForeground(OTHER_FOREGROUND == null ? this.defaultForeground : OTHER_FOREGROUND);
                    this.setBackground(OTHER_BACKGROUND == null ? this.defaultBackground : OTHER_BACKGROUND);
                }
            }

            boolean isActualDate() {
                return DialogPanel.this.sameDay(this.getDate(), DialogPanel.this.getActualDate(), DialogPanel.this.calendar);
            }

            private class DateAction
            extends AbstractAction {
                private Date date;

                DateAction(Date d) {
                    this.setDate(d);
                }

                void setDate(Date d) {
                    this.date = d;
                    DialogPanel.this.calendar.setTime(d);
                    this.putValue("Name", String.valueOf(DialogPanel.this.calendar.get(5)));
                }

                Date getDate() {
                    return this.date;
                }

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DialogPanel.this.setDate(this.date);
                    DialogPanel.this.setActualDate(this.date);
                    DatePopupDialog.this.setVisible(false);
                }
            }
        }

        class KeyNavigationAction
        extends AbstractKeyAction {
            JComponent target;

            protected KeyNavigationAction(String key, JComponent source, JComponent target) {
                super(key);
                this.target = target;
                this.addKey(source, key);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.target.requestFocusInWindow();
            }
        }

        class CancelAction
        extends AbstractAction {
            CancelAction() {
                this.putValue("Name", "Cancel");
                this.putValue("ShortDescription", "Dismiss the dialog");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DatePopupDialog.this.setVisible(false);
            }
        }

        class OKAction
        extends AbstractAction {
            OKAction() {
                this.putValue("Name", "OK");
                this.putValue("ShortDescription", "Confirm the date.");
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                Component focusOwner = DatePopupDialog.this.getFocusOwner();
                if (focusOwner instanceof DateButton) {
                    DateButton dateButton = (DateButton)focusOwner;
                    dateButton.doClick();
                }
                DialogPanel.this.setDate(DialogPanel.this.getActualDate());
                DatePopupDialog.this.setVisible(false);
            }
        }

        class DialogPanelTraversalPolicy
        extends LayoutFocusTraversalPolicy {
            DialogPanelTraversalPolicy() {
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                for (DateButton button : DialogPanel.this.buttons) {
                    if (!button.isActualDate()) continue;
                    return button;
                }
                return super.getDefaultComponent(aContainer);
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (aComponent instanceof DateButton) {
                    while ((aComponent = super.getComponentAfter(aContainer, aComponent)) instanceof DateButton) {
                    }
                } else {
                    aComponent = super.getComponentAfter(aContainer, aComponent);
                }
                return aComponent;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                if (aComponent instanceof DateButton) {
                    while ((aComponent = super.getComponentBefore(aContainer, aComponent)) instanceof DateButton) {
                    }
                } else {
                    aComponent = super.getComponentBefore(aContainer, aComponent);
                }
                return aComponent;
            }
        }
    }
}

